package com.gingersoft.gsa.cloud.table.mvp.action.order;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.pos.AdjustTipRequest;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.gingersoft.gsa.cloud.ui.widget.dialog.KeyboardDialog;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.mvp.IView;

/**
 * @作者: bin
 * @創建時間: 2021-01-15 15:19
 * @更新時間: 2021-01-15 15:19
 * @描述:補小費
 */
public class TipsOrder implements Strategy<OrderManagerResponse> {

    private final  String TAG = "TipsOrder";
    private BaseFragmentActivity mActivity;
    private IView mRootView;

    public TipsOrder(BaseFragmentActivity fragmentActivity, IView rootView){
        this.mActivity  = fragmentActivity;
        this.mRootView = rootView;
    }

    @Override
    public void action(OrderManagerResponse orderItem) {
        showKeyboardDialog(orderItem);
    }

    @Override
    public void destroy() {
        mActivity = null;
        mRootView = null;
    }

    private void showKeyboardDialog(OrderManagerResponse datasBean) {
        new KeyboardDialog(mActivity)
                .build()
                .setOnCallBackListener(new KeyboardDialog.OnCallBackListener() {
                    @Override
                    public void onSure(String number) {
                        if (!TextUtils.isEmpty(number)) {

                            GetTxnIdRequest txnIdRequest = new GetTxnIdRequest();
                            txnIdRequest.setOrderId(datasBean.getId());
                            if (!TextUtils.isEmpty(datasBean.getTableNumber())) {
                                txnIdRequest.setTableExtId(datasBean.getTableId());
                            } else {
                                txnIdRequest.setTableId(datasBean.getTableId());
                            }
                            txnIdRequest.setAmount(datasBean.getAmount());

//                            PosPay.tip(mActivity, mRootView, txnIdRequest,
//                                    getTipsRequest(datasBean.getPayTxnId(), datasBean.getAmount(), Double.parseDouble(number)), new OnPosActionListener<AdjustTipRespose>() {
//
//                                        @Override
//                                        public void onPosSuccess(AdjustTipRespose response) {
//                                            LoganManager.w_order(TAG, "onPosSuccess: " + response.toString());
//                                            if(tipsListener != null){
//                                                tipsListener.refeshOrders();
//                                            }
//                                        }
//
//                                        @Override
//                                        public void onPosException(AdjustTipRespose response,Exception e) {
//                                            LoganManager.w_order(TAG, "onPosException: " + e.getMessage());
//                                            PosActionStatusExceptionFragment statusExceptionFragment = (PosActionStatusExceptionFragment) mActivity.findFragment(PosActionStatusExceptionFragment.class);
//                                            if (statusExceptionFragment == null) {
//                                                PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
//                                                statusExceptionParam.setTxnId(datasBean.getPayTxnId());
//                                                statusExceptionParam.setAmount(datasBean.getAmount());
//                                                statusExceptionParam.setOrderId(datasBean.getId());
//                                                statusExceptionParam.setOrderNo(datasBean.getOrderNo());
//                                                statusExceptionParam.setPayMethodName("VISA測試");
//                                                statusExceptionParam.setPosAction(PosAction.TIP);
//                                                mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
//                                            }else{
//                                                mActivity.start(statusExceptionFragment);
//                                            }
//                                        }
//
//                                        @Override
//                                        public void onPosInvalid(String e) {
//                                            LoganManager.w_order(TAG, "onPosInvalid: " + e.toString());
//                                        }
//
//                                        @Override
//                                        public void onUpdateStatusSuccess(AdjustTipRespose response) {
//                                            LoganManager.w_order(TAG, "onUpdateStatusSuccess: " + response.toString());
//                                        }
//
//                                        @Override
//                                        public void onUpdateStatusError(Throwable e) {
//                                            LoganManager.w_order(TAG, "onUpdateStatusError: " + e.getMessage());
//                                            PosActionStatusExceptionFragment statusExceptionFragment = (PosActionStatusExceptionFragment) mActivity.findFragment(PosActionStatusExceptionFragment.class);
//                                            if (statusExceptionFragment == null) {
//                                                PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
//                                                statusExceptionParam.setTxnId(datasBean.getPayTxnId());
//                                                statusExceptionParam.setAmount(datasBean.getAmount());
//                                                statusExceptionParam.setOrderId(datasBean.getId());
//                                                statusExceptionParam.setOrderNo(datasBean.getOrderNo());
//                                                statusExceptionParam.setPayMethodName("VISA測試");
//                                                statusExceptionParam.setPosAction(PosAction.TIP);
//                                                mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
//                                            }else{
//                                                mActivity.start(statusExceptionFragment);
//                                            }
//                                        }
//                                    });
                        }
                    }
                })
                .show();
    }

    private AdjustTipRequest getTipsRequest(String txnId, double amount, double tips) {
        AdjustTipRequest tipRequest = new AdjustTipRequest();
        tipRequest.setTXN_ID(txnId);
        tipRequest.setTOTAL_TXN_AMT(MoneyUtil.sum(amount, tips));
        return tipRequest;
    }

    private TipsOrder.OnRefundListener tipsListener;
    public void setTipsListener(TipsOrder.OnRefundListener tipsListener) {
        this.tipsListener = tipsListener;
    }
    public interface OnRefundListener{
        void refeshOrders();
    }
    
}
