package com.gingersoft.gsa.cloud.table.mvp.presenter.orderManager;

import android.app.Application;
import android.content.Context;
import android.content.Intent;

import com.gingersoft.gsa.cloud.pay.bean.PosActionStatusExceptionParam;
import com.gingersoft.gsa.cloud.pay.device.pos.base.fragment.PosActionStatusExceptionFragment;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.contract.AllOrderContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.orderManager.OrderCenterActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.orderManager.OrderDetailActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.OrderCenterAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.AllOrderFragment;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/13/2020 16:25
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class AllOrderPresenter extends BasePresenter<AllOrderContract.Model, AllOrderContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private OrderCenterActivity IActivity;

    private OrderCenterAdapter mOrderCenterAdapter;
    private List<OrderManagerResponse> mOrderItemList = new ArrayList<>();

    private OrderManagerResponse mCheckedOrderBean;

    @Inject
    public AllOrderPresenter(AllOrderContract.Model model, AllOrderContract.View rootView) {
        super(model, rootView);
        AllOrderFragment allOrderFragment = (AllOrderFragment) rootView;
        this.IActivity = (OrderCenterActivity) allOrderFragment.getCurrentActivity();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
        this.IActivity = null;
    }

    public void initOrderAdapter(Context context) {
        if (mOrderCenterAdapter == null) {
            mOrderCenterAdapter = new OrderCenterAdapter(context, mOrderItemList);
            mRootView.setAllOrderAdapter(mOrderCenterAdapter);
        }
        mOrderCenterAdapter.setOnItemClickListener(new OrderCenterAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(OrderManagerResponse datasBean, int position) {
                Intent intent = new Intent(IActivity, OrderDetailActivity.class);
                intent.putExtra("orderDetailItem", datasBean);
                mRootView.launchActivity(intent);
            }

            @Override
            public void onCheckedChanged(OrderManagerResponse checkedOrder) {
                if (checkedOrder.isChecked()) {
                    mCheckedOrderBean = checkedOrder;
                } else {
                    mCheckedOrderBean = null;
                }
                IActivity.setOnCheckedChangedListener(mCheckedOrderBean);
            }

            @Override
            public void onReloadExceptionStatus(OrderManagerResponse orderBean, String txnId) {
                PosActionStatusExceptionFragment statusExceptionFragment =  IActivity.findFragment(PosActionStatusExceptionFragment.class);
                if (statusExceptionFragment == null) {
                    PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
                    statusExceptionParam.setTxnId(txnId);
                    statusExceptionParam.setAmount(orderBean.getTotalAmount());
                    statusExceptionParam.setOrderId(orderBean.getId());
                    statusExceptionParam.setOrderNo(orderBean.getOrderNo());
                    statusExceptionParam.setPayMethodName(orderBean.getPayNames());
                    statusExceptionParam.setPosAction(orderBean.getPosActionByMatterId());
                    IActivity.loadRootFragment(R.id.fl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
                }else {
                    IActivity.start(statusExceptionFragment);
                }
            }
        });
    }

    public void updateOrderData(List<OrderManagerResponse> orderItemList) {
        if (orderItemList != null) {
            mOrderItemList.clear();
            mOrderItemList.addAll(orderItemList);
            mOrderCenterAdapter.notifyDataSetChanged();
        }
    }

    public void addOrderItem(List<OrderManagerResponse> orderItemList) {
        if (orderItemList != null) {
            mOrderItemList.addAll(orderItemList);
            mOrderCenterAdapter.notifyDataSetChanged();
        }
    }

    public OrderManagerResponse getCheckedOrderBean() {
        return mCheckedOrderBean;
    }

}
