package com.gingersoft.gsa.cloud.table.mvp.ui.activity;

import android.os.Bundle;
import android.view.View;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;

import com.gingersoft.gsa.cloud.common.utils.threadPool.ThreadPoolManager;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.google.android.material.bottomappbar.BottomAppBar;
import com.google.android.material.bottomappbar.BottomAppBarTopEdgeTreatment;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.navigation.NavigationView;
import com.google.android.material.shape.CutCornerTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.mvp.BaseModel;
import com.jess.arms.mvp.BasePresenter;

import java.util.Timer;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

import butterknife.BindView;
import io.reactivex.internal.schedulers.ScheduledDirectTask;

/**
 * @作者: bin
 * @創建時間: 2021-02-02 11:42
 * @更新時間: 2021-02-02 11:42
 * @描述:
 */
public class CoordinatorlayoutActivity extends BaseActivity{

//    @BindView(R2.id.coordinator_layout)
    CoordinatorLayout coordinatorLayout;
//    @BindView(R2.id.fab)
    FloatingActionButton fab;
//    @BindView(R2.id.bar)
    BottomAppBar bar;

//    @BindView(R2.id.bottom_drawer)
//    FrameLayout bottomDrawer;
//    @BindView(R2.id.navigation_view)
//    NavigationView navigationView;

    private BottomSheetBehavior<View> bottomDrawerBehavior;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {

    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activitiy_coordinator;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        coordinatorLayout = findViewById(R.id.coordinator_layout);
        fab = findViewById(R.id.fab);
        bar = findViewById(R.id.bar);
//        bottomDrawer = findViewById(R.id.bottom_drawer);
//        navigationView = findViewById(R.id.navigation_view);
        setUpBottomDrawer();
        setUpBottomAppBarShapeAppearance();
    }

    private void setUpBottomAppBarShapeAppearance() {
        ShapeAppearanceModel fabShapeAppearanceModel = fab.getShapeAppearanceModel();
        boolean cutCornersFab =
                fabShapeAppearanceModel.getBottomLeftCorner() instanceof CutCornerTreatment
                        && fabShapeAppearanceModel.getBottomRightCorner() instanceof CutCornerTreatment;

        BottomAppBarTopEdgeTreatment topEdge =
                cutCornersFab
                        ? new BottomAppBarCutCornersTopEdge(
                        bar.getFabCradleMargin(),
                        bar.getFabCradleRoundedCornerRadius(),
                        bar.getCradleVerticalOffset())
                        : new BottomAppBarTopEdgeTreatment(
                        bar.getFabCradleMargin(),
                        bar.getFabCradleRoundedCornerRadius(),
                        bar.getCradleVerticalOffset());

        MaterialShapeDrawable babBackground = (MaterialShapeDrawable) bar.getBackground();
        babBackground.setShapeAppearanceModel(babBackground.getShapeAppearanceModel().toBuilder().setTopEdge(topEdge).build());
    }

    protected void setUpBottomDrawer() {
//        bottomDrawerBehavior = BottomSheetBehavior.from(bottomDrawer);
//        bottomDrawerBehavior.setState(BottomSheetBehavior.STATE_HIDDEN);
//
//        bar.setNavigationOnClickListener(v -> bottomDrawerBehavior.setState(BottomSheetBehavior.STATE_HALF_EXPANDED));
//        bar.setNavigationIcon(R.drawable.ic_add_have_border);
//        bar.replaceMenu(R.menu.demo_primary);
    }

    @Override
    public void initIntent() {
    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }
}
