package com.gingersoft.gsa.cloud.table.mvp.ui.activity;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.Chronometer;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.constans.FoodSummaryConstans;
import com.gingersoft.gsa.cloud.common.constans.MealConstant;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.scan.ScanHelper;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.common.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.order.bean.response.OrderResponse;
import com.gingersoft.gsa.cloud.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.order.billItem.DiscountItem;
import com.gingersoft.gsa.cloud.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.discount.MemberDiscount;
import com.gingersoft.gsa.cloud.order.discount.MultyDiscount;
import com.gingersoft.gsa.cloud.order.order.BaseOrder;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.print.PrinterUtils;
import com.gingersoft.gsa.cloud.table.BuildConfig;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerMealStand2Component;
import com.gingersoft.gsa.cloud.table.di.component.DaggerMealStandComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.event.InitTableEvent;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.MealStandPresenter;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.MealStandPresenter2;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.BaseFragmentAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodGroupAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.SelectMealAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.FineItemAllFragment;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.mealstand.SetMealFragment;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.ChooseNumberDialog;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.CustomFoodDialog;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.UseMemberDialog;
import com.gingersoft.gsa.cloud.ui.recylcler.Indicator.PagerConfig;
import com.gingersoft.gsa.cloud.ui.recylcler.Indicator.PagerGridLayoutManager;
import com.gingersoft.gsa.cloud.ui.recylcler.Indicator.PagerGridSnapHelper;
import com.gingersoft.gsa.cloud.ui.recylcler.RecyclerViewNoBugLinearLayoutManager;
import com.gingersoft.gsa.cloud.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.gsa.cloud.ui.recylcler.decorator.GridDividerItemDecoration;
import com.gingersoft.gsa.cloud.ui.view.PagerSlidingTabStrip;
import com.gingersoft.gsa.cloud.ui.view.SearchKeyBoardView;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.gyf.immersionbar.ImmersionBar;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

import org.simple.eventbus.EventBus;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.inject.Inject;
import javax.inject.Named;

import butterknife.BindView;
import butterknife.OnClick;
import butterknife.OnLongClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class MealStandActivity2 extends BaseFragmentActivity<MealStandPresenter2> implements MealStandContract.View, PagerGridLayoutManager.PageListener {

    private SparseArray<View> map = new SparseArray<>(10);

    @BindView(R2.id.meal_stand_search_keyboard_view)
    SearchKeyBoardView keyboard_view;
    @BindView(R2.id.fl_meal_discount)
    FrameLayout fl_meal_discount;

    private int mCurrentViewMode;
    private boolean isPluMode;
    private static final int ORDER_CONTENT_CODE = 1002;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerMealStand2Component //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        EventBus.getDefault().registerSticky(this);
        super.onCreate(savedInstanceState);
    }

    @Override
    public void configImmersionBar(ImmersionBar immersionBar) {
        immersionBar
                .fitsSystemWindows(true)
                .statusBarColor(R.color.theme_white_color)
                .statusBarDarkFont(true)
                .init();
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.table_activity_meal_stand2; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        if (findFragment(SetMealFragment.class) == null) {
            loadRootFragment(R.id.fl_food_plate, SetMealFragment.newInstance());
        }
    }


    @Override
    public boolean isInitFineItemLayout() {
        return true;
    }

    @Override
    public int getRestaurantId() {
        return RestaurantInfoManager.newInstance().getRestaurantId();
    }

    @Override
    public void initFineItemTabBarViewPage() {
    }

    @Override
    public void setCurrentFinePage() {
    }

    @Override
    public void setPluMode() {
    }

    @Override
    public void resetPluMode() {
    }


    @Override
    public void updateMemberInfo(MemberInfo memberInfo) {
    }

    @OnClick({ R2.id.btn_send_order, R2.id.tv_no_save_return, R2.id.tv_order_content})
    public void onClick(View v) {

        recordOperat(true);

        //防抖處理
        int id = v.getId();
        if (id == R.id.btn_numberman) {
            if (!BaseOrder.isTableToMeal()) {
                return;
            }
            showChoosePeopleNumDialog(true);
        } else if (id == R.id.btn_fid) {
            setPluMode();
        } else if (id == R.id.btn_send_order) {
            if (BaseOrder.isCurrentOrderType(FoodSummaryConstans.TAKEAWAY_TYPE)) {
                CC.obtainBuilder(ComponentName.COMPONENT_DELIVERYPICK)
                        .setActionName("SendOrder")
                        .build()
                        .call();
                return;
            }
            mPresenter.sendOrder(false, null);
        } else if (id == R.id.tv_order_content) {
            //如果打印成功會回調
            Intent intent = new Intent(mContext, OrderContentActivity.class);
            startActivityForResult(intent, ORDER_CONTENT_CODE);
        } else if (id == R.id.tv_no_save_return) {
            returnTableActivity(true);
        }
    }

    @Override
    public void onBackPressedSupport() {
        returnTableActivity(true);
    }

    public void returnTableActivity(boolean initTable) {
        if (mPresenter.hasNesOrderFoods()) {
            //没有过重复下单提示且有未送单食品，提示用户
            String tip = LanguageUtils.get_language_system(this, "food.not.delivered.tip", "有食品未送單, 確認離開?");
            Class[] parameterTypes = {boolean.class};
            Object[] parameters = {initTable};
            CommonTipDialog.showSurpisedDialog(this, tip, MealStandActivity2.class, this,
                    "returnBeforeActivity", parameterTypes, parameters);
        } else {
            returnBeforeActivity(initTable);
        }
    }

    public void returnBeforeActivity(boolean initTable) {
        if (BaseOrder.isTableToMeal() && initTable && !DoshokuOrder.getInstance().isModifyOrder()) {
            TableBean.DataBean dataBean = DoshokuOrder.getInstance().getOpenTableInfo();
            if (dataBean != null) {
                //通知更新餐台状态
                EventBus.getDefault().post(new InitTableEvent(dataBean.getId(), dataBean.getTableNumber()), "initTable_status_event");
            }
        }
        killMyself();
    }

    @Override
    public void recordOperat(boolean isPressButtonSound) {
        if (isPressButtonSound) {
            VibratorUtils.pressButtonSound(this);
        }
    }

    @Override
    public void showChoosePeopleNumDialog(boolean isNeedCancel) {
    }

    @Override
    public void setPrinterLocalmachine(boolean isPrint) {

    }

    @Override
    public void setTableInfoDialogAdapter(BaseAdapter adapter) {

    }

    @Override
    public void setSelectFoodAdapter(RecyclerView.Adapter adapter) {
    }

    @Override
    public void setFoodGroupAdapter(DefaultAdapter adapter) {
    }

    @Override
    public void setFoodAdapter(DefaultAdapter adapter) {
    }

    @Override
    public void setOrderDetailAdapter(DefaultAdapter adapter) {

    }

    @Override
    public void setComboAdapter(DefaultAdapter adapter) {
    }

    @Override
    public void setModifierAdapter(DefaultAdapter adapter) {
    }

    @Override
    public void setDiscountAdapter(DefaultAdapter adapter) {
    }

    private GridLayoutManager foodRecycleLayoutManager, comboRecycleLayoutManager, modifierRecycleLayoutManager, discountRecycleLayoutManager;

    @Override
    public void setSelectFoodRecycleLayoutManager() {
    }

    @Override
    public void setFoodGroupRecycleLayoutManager(int orientation) {

    }

    @Override
    public void setFoodRecycleLayoutManager(int orientation) {
    }

    @Override
    public void setComboRecycleLayoutManager(int orientation) {
    }

    @Override
    public void setModifierRecycleLayoutManager(int orientation) {
    }

    @Override
    public void setDiscountRecycleLayoutManager(int orientation) {
    }

    @Override
    public void setFoodGroupRecycleSpanCount(int size) {
    }

    @Override
    public void setFoodRecycleSpanCount(int size) {
    }

    @Override
    public void setComboRecycleSpanCount(int size) {
    }

    @Override
    public void setModifierRecycleSpanCount(int size) {
    }

    @Override
    public void setDiscountRecycleSpanCount(int size) {
    }

    @Override
    public void showViewModeVisibility(int... viewMode) {
        //將所有的view隱藏
        for (int i = 0; i < map.size(); i++) {
            map.valueAt(i).setVisibility(View.INVISIBLE);
        }
        //設置當前mode為第一個傳入的mode
        for (int mode : viewMode) {
            this.mCurrentViewMode = mode;
            break;
        }
        //顯示所有傳入的需要顯示的view
        for (int mode : viewMode) {
            map.get(mode).setVisibility(View.VISIBLE);
        }
        //設置當前模式為輸入Plu模式
        if (viewMode != null && viewMode[0] == MealConstant.ViewMode_keys) {
            isPluMode = true;
        } else {
            isPluMode = false;
        }
        switch (mCurrentViewMode) {
            case MealConstant.food_group_ViewMode:
            case MealConstant.food_ViewMode:
                showModifyLayoutVisibility(false);
                break;
            case MealConstant.combo_ViewMode:
//            case MealConstant.modifier_ViewMode:
            case MealConstant.discount_ViewMode:
            case MealConstant.fine_ViewMode:
                showModifyLayoutVisibility(true);
                break;
            default:
                break;
        }
    }

    @Override
    public void showModifyLayoutVisibility(boolean show) {
    }

    @Override
    public void setOrderFoodCount(String number) {
    }

    @Override
    public void setMealRvScrollToPosition(int position) {
    }

    @Override
    public List<Food> getFoodGroupList() {
        return null;
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {
    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(this, message, true);
        else
            LoadingDialog.showDialogForLoading(this);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(MealStandActivity2.this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public Activity getActivity() {
        return this;
    }

    @Override
    public int getFromType() {
        return 1;
    }

    public void clearInput() {
    }

    /**
     * 显示公共信息
     */
    public void showRemarkLayout() {
        //没有初始化细项布局则初始化
        if (!isInitFineItemLayout()) {

        } else {
            setCurrentFinePage();
            showViewModeVisibility(MealConstant.fine_ViewMode, MealConstant.fine_tabs_ViewMode);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == ORDER_CONTENT_CODE) {
            //訂單內容回調
            if (resultCode == Activity.RESULT_OK) {
                //打印成功
                //結賬成功
                //關閉當前頁面
                killMyself();
            }
        } else if (requestCode == ScanHelper.CALL_BACK_QR_RESULT) {
            String qrCodeResult = data.getStringExtra("qrCodeResult");
            if (TextUtils.isEmpty(qrCodeResult)) {
                return;
            }
            TableBean.DataBean dataBean = DoshokuOrder.getInstance().getOpenTableInfo();
//            mPresenter.queryMember(1, qrCodeResult, RestaurantInfoManager.newInstance().getGsPosShopId(), dataBean.getId(), dataBean.getTableNumber());
        }
    }

    public int getCurrentViewMode() {
        return mCurrentViewMode;
    }

    @Override
    public void onPageSizeChanged(int pageSize) {
    }

    @Override
    public void onPageSelect(int pageIndex) {
    }

    @Override
    public void setModifierTop(int margins) {
    }

    @Override
    public void setCustomFoodDialog(int customType, OrderDetail foodItem) {
        new CustomFoodDialog(mContext, customType)
                .create(R.style.MyEditDialogTheme)
                .setOnEditListener((dialog, name, money) -> {
                    dialog.dismiss();
                    if (customType == Food.CUSTOM_TYPE_101) {
                        foodItem.setProductName(name);
                    }
                    if (!TextUtils.isEmpty(money)) {
                        foodItem.setUnit_price(Double.parseDouble(money));
                        foodItem.setPrice(foodItem.getUnit_price());
//                        mPresenter.toAddFoodItem(foodItem);
                    }
                })
                .show();
    }

    @Override
    public void showBtnMealModifyRestoreVisibility(boolean show) {
    }

    private void setSelectFunctionVisibility(int visibility) {
    }
}
