package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiCheckInputBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiInputBean;
import com.google.android.material.textfield.TextInputEditText;

import org.jetbrains.annotations.NotNull;

import java.util.List;

import butterknife.ButterKnife;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/26
 * Time: 15:20
 * Use:
 */
public class MultiCheckProvider<T extends InfoMultiBean> extends InputProvider<T> {

    public MultiCheckProvider(Context context) {

    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_MULTIPLE_CHECKBOX;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_checkbox_input;
    }

    @Override
    public @NotNull InputViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        return new InputViewHolder(LayoutInflater.from(context).inflate(getLayoutId(), parent, false));
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T t) {
        super.convert(baseViewHolder, t);
        MultiCheckInputBean infoMultiBean = (MultiCheckInputBean) t;
        InputViewHolder viewHolder = (InputViewHolder) baseViewHolder;

        viewHolder.setImageResource(R.id.iv_multi_check_img, infoMultiBean.getIconId());
        CheckBox checkBox = viewHolder.getView(R.id.cb_multi_check);
        checkBox.setChecked(infoMultiBean.isChecked());
        if (infoMultiBean.isDefault()) {
            viewHolder.setGone(R.id.cb_multi_check, true);
            viewHolder.setGone(R.id.tv_multi_default, false);
        } else {
            viewHolder.setGone(R.id.cb_multi_check, false);
            viewHolder.setGone(R.id.tv_multi_default, true);
        }
        viewHolder.setTextColor(R.id.ed_multi_value, ContextCompat.getColor(context, R.color.color_3c));
    }
}
