package com.gingersoft.gsa.cloud.ui.bean;

import android.view.View;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.R2;
import com.gingersoft.gsa.cloud.ui.R;
import com.jess.arms.utils.ArmsUtils;

import butterknife.BindColor;
import butterknife.BindDimen;
import butterknife.ButterKnife;
import lombok.Data;

/**
 * @作者: bin
 * @創建時間: 2021-04-06 15:14
 * @更新時間: 2021-04-06 15:14
 * @描述:
 */
@Data
public class TagViewItem<T> {

    private long id;
    private String text;

    int textSize = 14;

    //选择字体颜色
    int checkedTextColor;

    //未选择字体颜色
    int unCheckedTextColor;

    //边线颜色
    int sidelineColor;

    //选择背景色
    int checkedBgColor;

    //未选择背景色
    int unCheckedBgColor;

    boolean checked = false;

    //目标对象
    private T targetObj;

    public TagViewItem() {
        checkedTextColor = ArmsUtils.getColor(GsaCloudApplication.getAppContext(), R.color.theme_grey_color);
        unCheckedTextColor = ArmsUtils.getColor(GsaCloudApplication.getAppContext(), R.color.theme_grey_color);
        sidelineColor = ArmsUtils.getColor(GsaCloudApplication.getAppContext(), R.color.theme_grey_color);
        checkedBgColor = ArmsUtils.getColor(GsaCloudApplication.getAppContext(), R.color.theme_color);
        unCheckedBgColor = ArmsUtils.getColor(GsaCloudApplication.getAppContext(), R.color.theme_white_color);
    }
}
