package com.gingersoft.gsa.cloud.table.mvp.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.gingersoft.gsa.cloud.table.di.component.DaggerStateTableComponent;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.StateTableContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.StateTablePresenter;

import com.gingersoft.gsa.cloud.table.R;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2019 17:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class StateTableFragment extends BaseFragment<StateTablePresenter> implements StateTableContract.View {


    @BindView(R.id.recycle_state_table)
    RecyclerView recycle_state_table;

    private TableActivity mActivity;
    private List<TableBean.DataBean> datasBeans;
    private int status;


    public static StateTableFragment newInstance() {
        StateTableFragment fragment = new StateTableFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerStateTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_fragment_state_table, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        this.mActivity = (TableActivity) getActivity();
    }

    @Override
    public void setData(@Nullable Object data) {
        if (data != null && data instanceof Message) {
            switch (((Message) data).what) {
                case 0:
                    break;
                case 1://刷新全部数据
                    datasBeans = (List<TableBean.DataBean>) ((Message) data).obj;
                    status = ((Message) data).arg1;
                    if (mPresenter != null) {
                        //recycleView正在滑动
                        if (recycle_state_table.getScrollState() != 0) {
                        } else {
                            mPresenter.updateAllTableData(mActivity, datasBeans,status);
                        }
                    }
                    break;
                case 2://刷新状态已变数据
                    datasBeans = (List<TableBean.DataBean>) ((Message) data).obj;
                    if (mPresenter != null) {
                        //recycleView正在滑动
                        if (recycle_state_table.getScrollState() != 0) {
                        } else {
                            mPresenter.updataTableItem(datasBeans);
                        }
                    }
                    break;
                default:
                    //do something
                    break;
            }
        }
    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }


    @Override
    public void setStateTableAdapter(DefaultAdapter adapter) {
        recycle_state_table.setAdapter(adapter);
        initStateTableRecycleViewLayout();
    }

    private GridLayoutManager mStateTableRecycleLayoutManager;

    private void initStateTableRecycleViewLayout() {
//        if (GSAApplication.androidSetting.getTableDirection() == 2) { //横向展示
//            mStateTableRecycleLayoutManager = new GridLayoutManager(getActivity(), 5, LinearLayoutManager.HORIZONTAL, false);
//            recycle_state_table.setLayoutManager(mStateTableRecycleLayoutManager);
//            recycle_state_table.setItemAnimator(new DefaultItemAnimator());
//            recycle_state_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.HORIZONTAL));
//            recycle_state_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.VERTICAL));
//        } else {
            mStateTableRecycleLayoutManager = new GridLayoutManager(getActivity(), 4, LinearLayoutManager.VERTICAL, false);
            recycle_state_table.setLayoutManager(mStateTableRecycleLayoutManager);
            recycle_state_table.setItemAnimator(new DefaultItemAnimator());
            recycle_state_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.HORIZONTAL));
            recycle_state_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.VERTICAL));
//        }
    }
}
