package com.gingersoft.gsa.cloud.mealstand.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.gsa.cloud.mealstand.di.module.MealStandModule;
import com.gingersoft.gsa.cloud.mealstand.mvp.contract.MealStandContract;

import com.jess.arms.di.scope.ActivityScope;
import com.gingersoft.gsa.cloud.mealstand.mvp.ui.activity.MealStandActivity;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
@Component(modules = MealStandModule.class, dependencies = AppComponent.class)
public interface MealStandComponent {
    void inject(MealStandActivity activity);

    @Component.Builder
    interface Builder {
        @BindsInstance
        MealStandComponent.Builder view(MealStandContract.View view);

        MealStandComponent.Builder appComponent(AppComponent appComponent);

        MealStandComponent build();
    }
}