package com.gingersoft.gsa.cloud.mealstand.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.Chronometer;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gingersoft.gsa.cloud.mealstand.di.component.DaggerMealStandComponent;
import com.gingersoft.gsa.cloud.ui.view.PagerSlidingTabStrip;
import com.gingersoft.gsa.cloud.ui.view.SearchKeyBoardView;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.mealstand.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.mealstand.mvp.presenter.MealStandPresenter;
import com.gingersoft.gsa.cloud.mealstand.R;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import butterknife.BindView;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class MealStandActivity extends BaseActivity<MealStandPresenter> implements MealStandContract.View {

    @BindView(R.id.ctime)
    Chronometer chronometer;

    @BindView(R.id.rv_select_meal)
    RecyclerView rv_select_meal;

    @BindView(R.id.rv_food_group)
    RecyclerView rv_food_group;
    @BindView(R.id.rv_food)
    RecyclerView rv_food;
    @BindView(R.id.rv_combo)
    RecyclerView rv_combo;
    @BindView(R.id.rv_discount)
    RecyclerView rv_discount;

    @BindView(R.id.rl_fine_tabs)
    RelativeLayout rl_fine_tabs;
    @BindView(R.id.iv_fine_back)
    ImageView iv_fine_back;
    @BindView(R.id.tabs_fine)
    PagerSlidingTabStrip tabs_fine;
    @BindView(R.id.pager_fine)
    ViewPager pager_fine;
    @BindView(R.id.meal_stand_search_keyboard_view)
    SearchKeyBoardView keyView;

    @BindView(R.id.rl_stand_oper)
    RelativeLayout rl_stand_oper;
    @BindView(R.id.tv_no_save_return)
    TextView tv_no_save_return;
//    @BindView(R.id.tv_send_order)
//    TextView tv_send_order;

    @BindView(R.id.fl_order_content)
    FrameLayout fl_order_content;
    @BindView(R.id.tv_order_content)
    TextView tv_order_content;
    @BindView(R.id.btn_order_count)
    Button btn_order_count;

    //送单
    @BindView(R.id.fl_send_order)
    FrameLayout fl_send_order;
    @BindView(R.id.btn_send_order)
    Button btn_send_order;
//    @BindView(R.id.btn_send_order_machine_name)
//    TextView btn_send_order_machine_name;

    //印单
    @BindView(R.id.fl_printer_order)
    FrameLayout fl_printer_order;
    @BindView(R.id.btn_order_printer)
    Button btn_order_printer;
    @BindView(R.id.btn_printer_machine_name)
    TextView btn_printer_machine_name;

    @BindView(R.id.ll_meals)
    LinearLayout ll_meals;
    @BindView(R.id.ll_meals_main)
    LinearLayout ll_meals_main;
    @BindView(R.id.ll_mm)
    LinearLayout ll_mm;

    @BindView(R.id.btn_table)
    Button btn_table;
    @BindView(R.id.btn_numberman)
    Button btn_numberman;
    @BindView(R.id.btn_fid)
    TextView btn_fid;
    @BindView(R.id.btn_temporary)
    TextView btn_temporary;
    @BindView(R.id.btn_meal_discount)
    TextView btn_meal_discount;
    @BindView(R.id.btn_meal_delete)
    TextView btn_meal_delete;
    @BindView(R.id.btn_meal_modify_restore)
    ImageButton btn_meal_modify_restore;
    @BindView(R.id.btn_change_Language)
    ImageButton btn_change_Language;
    @BindView(R.id.btn_food_merge)
    ImageButton btn_food_merge;
    @BindView(R.id.btn_food_mode)
    TextView btn_food_mode;


    @BindView(R.id.ll_Keys)
    LinearLayout ll_Keys;
    @BindView(R.id.btn_key0)
    Button btn_key0;
    @BindView(R.id.btn_key1)
    Button btn_key1;
    @BindView(R.id.btn_key2)
    Button btn_key2;
    @BindView(R.id.btn_key3)
    Button btn_key3;
    @BindView(R.id.btn_key4)
    Button btn_key4;
    @BindView(R.id.btn_keys)
    Button btn_keys;

    @BindView(R.id.ll_modify)
    LinearLayout ll_modify;
    @BindView(R.id.btn_add_delete)
    Button btn_add_delete;
    @BindView(R.id.btn_msg)
    Button btn_msg;
    @BindView(R.id.btn_delete)
    Button btn_delete;
    @BindView(R.id.btn_end)
    Button btn_end;


    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerMealStandComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.meal_activity_meal_stand; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
