package com.gingersoft.gsa.cloud.login.mvp.contract;

import android.content.Intent;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.constans.UserConstans;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.ui.bean.mode.BrandsBean;
import com.gingersoft.gsa.cloud.ui.bean.mode.LoginBean;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem;
import com.gingersoft.gsa.cloud.ui.widget.dialog.ChooseRestaurantDialog;
import com.gingersoft.gsa.cloud.login.mvp.presenter.BaseLoginPresenter;
import com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.ui.activity.SwitchServerActivity;
import com.jess.arms.base.BaseActivity;

import java.util.ArrayList;
import java.util.List;

public abstract class LoginInterfaceImpl<P extends BaseLoginPresenter> extends BaseActivity<P> implements BaseLoginContract.View {

    @Override
    public void loginSuccess(LoginBean info) {
        saveLoginInfo(info);
    }

    public void saveRestaurantListInfo(List<BrandsBean.BrandsData> brands) {
        int restaurantSize = 0;
        List<BrandsBean.BrandsData> brandsBeans = new ArrayList<>();
        if (brands != null) {
            String brandRestaurantInfos = JsonUtils.toJson(brands);
            GsaCloudApplication.setBrandRestaurantInfos(mContext, brandRestaurantInfos);
            restaurantSize = getRestaurantSize(brands);
            brandsBeans.addAll(brands);
        }
        boolean autoLogin = (boolean) SPUtils.get(mContext, UserConstans.AUTO_LOGIN, false);
        if (autoLogin) {
            int restaurantId = GsaCloudApplication.getRestaurantId(this);
            if (restaurantId != 0) {
                //有選擇餐廳，直接跳轉首頁
                jumpMainActivity();
                return;
            }
        }

        if (restaurantSize == 1) {
            //只有一個品牌是直接進下載頁面
            BrandsBean.BrandsData brandsBean = getOnlyBrand(brands);
            BrandsBean.BrandsData.RestaurantsBean restaurantsBean = getOnlyRestaurant(brands);
            if (brandsBean != null) {
                saveBrandAndRestaurantInfo(brandsBean.getBrandId(), brandsBean.getBrandName(), restaurantsBean.getRestaurantId(), restaurantsBean.getRestaurantName());
            }
            jumpDownloadActivity();
        } else {
            showChooseRestaurantDialog(brandsBeans, brands);
        }
    }

    @Override
    public void startToSwitchServer() {
        startActivity(new Intent(mContext, SwitchServerActivity.class));
    }

    private void saveLoginInfo(LoginBean loginBean) {
        GsaCloudApplication.setBrandRestaurantInfos(mContext, "");
        if (loginBean.getData() != null) {
            GsaCloudApplication.setLoginToken(mContext, loginBean.getData().getToken());
            if (loginBean.getData().getUser() != null) {
                GsaCloudApplication.setMemberId(mContext, loginBean.getData().getUser().getId());
                GsaCloudApplication.setMemberName(mContext, loginBean.getData().getUser().getUserName());
                //獲取餐廳
                mPresenter.getRestaurantList();
            }
        }
    }

    protected void ChooseRestaurantItemClick(List<BrandsBean.BrandsData> brands, ChooseRestaurantDialog dialog, SectionTextItem item) {
        BrandsBean.BrandsData brandsBean = getBrandByRestaurantId(brands, item.getId());
        if (brandsBean != null) {
            saveBrandAndRestaurantInfo(brandsBean.getBrandId(), brandsBean.getBrandName(), item.getId(), item.getText());
        }
        dialog.dismiss();
        jumpDownloadActivity();
    }

    protected void saveBrandAndRestaurantInfo(int brandId, String brandName, int restaurantId, String restaurantName) {
        GsaCloudApplication.setBrandId(mContext, brandId);
        GsaCloudApplication.setBrandName(mContext, brandName);
        GsaCloudApplication.setRestaurantId(mContext, restaurantId);
        GsaCloudApplication.setRestaurantName(mContext, restaurantName);
    }

    private int getRestaurantSize(List<BrandsBean.BrandsData> brands) {
        int size = 0;
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null)
                size += brands.get(i).getRestaurants().size();
        }
        return size;
    }

    private BrandsBean.BrandsData getOnlyBrand(List<BrandsBean.BrandsData> brands) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    return brands.get(i);
                }
            }
        }
        return null;
    }

    private BrandsBean.BrandsData.RestaurantsBean getOnlyRestaurant(List<BrandsBean.BrandsData> brands) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    return brands.get(i).getRestaurants().get(j);
                }
            }
        }
        return null;
    }

    private BrandsBean.BrandsData getBrandByRestaurantId(List<BrandsBean.BrandsData> brands, int restaurantId) {
        for (int i = 0; i < brands.size(); i++) {
            if (brands.get(i).getRestaurants() != null) {
                for (int j = 0; j < brands.get(i).getRestaurants().size(); j++) {
                    if (brands.get(i).getRestaurants().get(j).getRestaurantId() == restaurantId) {
                        return brands.get(i);
                    }
                }
            }
        }
        return null;
    }

    private void jumpDownloadActivity() {
        CC.obtainBuilder("Component.Download")
                .setActionName("showDownloadActivity")
                .addParam("fromPage", 1)
                .build()
                .call();
        killMyself();
    }

    private void jumpMainActivity() {
        CC.obtainBuilder("Component.Main")
                .setActionName("showMainActivity")
                .build()
                .call();
        killMyself();
    }
}
