package com.gingersoft.gsa.other_order_mode.util

import android.app.Activity
import android.app.Dialog
import android.view.View
import com.gingersoft.gsa.cloud.ui.utils.AppDialog
import com.gingersoft.gsa.other_order_mode.R

fun View.setState(state: Boolean) {
    visibility = if (state) {
        View.VISIBLE
    } else {
        View.GONE
    }
}


fun Activity.showWaringDialog(title: String, confirm: (Dialog) -> Unit, cancel: (Dialog) -> Unit) {
    AppDialog().showWaringDialog(this, title) { view, dialog ->
        when (view.id) {
            R.id.tv_dialog_confirm -> {
                confirm.invoke(dialog)
            }
            R.id.tv_dialog_cancel -> {
                cancel.invoke(dialog)
            }
        }
    }
}

