package com.gingersoft.gsa.other_order_mode.ui.adapter

import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.DeliveryBean

class DeliveryAdapter(data: MutableList<DeliveryBean.Data>) : BaseQuickAdapter<DeliveryBean.Data, BaseViewHolder>(R.layout.other_order_delivery_item, data) {
    override fun convert(holder: BaseViewHolder, item: DeliveryBean.Data) {
        holder.setText(R.id.tv_delivery_name, item.userName)
        if (holder.adapterPosition == selectIndex) {
            holder.setBackgroundResource(R.id.layout_delivery_item, R.drawable.shape_delivery_item_btn)
            holder.setTextColor(R.id.tv_delivery_name, context.resources.getColor(R.color.order_state0_color))
        } else {
            holder.setBackgroundResource(R.id.layout_delivery_item, R.drawable.shape_delivery_item_btn_normal)
            holder.setTextColor(R.id.tv_delivery_name, context.resources.getColor(R.color.color_c8))
        }
    }

    var selectIndex = -1

}
