package com.gingersoft.coldchain_module.mvp.ui.adapter;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.drawable.GradientDrawable;
import android.view.View;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.coldchain_module.R;
import com.gingersoft.coldchain_module.mvp.model.bean.OrderList;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static com.bin.david.form.utils.DensityUtils.dp2px;

public class OrderListAdapter extends BaseQuickAdapter<OrderList.DataBeanX.DataBean, BaseViewHolder> {


    public OrderListAdapter(@Nullable List<OrderList.DataBeanX.DataBean> data) {
        super(R.layout.cold_chain_order_item2, data);
    }


    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder, OrderList.DataBeanX.DataBean dataBean) {
        if (dataBean.getIsPrintPdf() == 0) {
            baseViewHolder.setText(R.id.tv_logistics_order_print_state, "未打印物流單");
            baseViewHolder.setGone(R.id.tv_logistics_order_print_state, false);
        } else {
            baseViewHolder.setGone(R.id.tv_logistics_order_print_state, true);
        }
        baseViewHolder.setText(R.id.tv_pay_method, dataBean.getOrderPayType() == 1 ? "貨到付款" : "在線支付");
        baseViewHolder.setText(R.id.tv_order_time, TimeUtils.parseTimeRepeat(dataBean.getCREATE_TIME(), TimeUtils.DEFAULT_DATE_FORMAT));
        if (TextUtil.isEmptyOrNullOrUndefined(dataBean.getRECEIVER())) {
            baseViewHolder.setText(R.id.tv_order_user_name, "(" + dataBean.getPHONE() + ")");
        } else {
            baseViewHolder.setText(R.id.tv_order_user_name, dataBean.getRECEIVER() + "(" + dataBean.getPHONE() + ")");
        }
        baseViewHolder.setText(R.id.tv_address, "地址：" + dataBean.getADDRESS_DETAIL());
        baseViewHolder.setText(R.id.tv_delivery_state, getStatus(dataBean.getCurStat()));
        baseViewHolder.setText(R.id.tv_order_amount, "$" + dataBean.getPAY_AMOUNT());

        if (dataBean.getIsRead() == 0) {
            baseViewHolder.setVisible(R.id.fl_border, true);
            alphaAnimator(baseViewHolder.getView(R.id.fl_border));
        } else {
            baseViewHolder.setGone(R.id.fl_border, true);
            baseViewHolder.getView(R.id.fl_border).clearAnimation();
        }

        String orderStatus = "";
        GradientDrawable statusBg = new GradientDrawable();
        statusBg.setCornerRadius(dp2px(getContext(), 5f));

        if (dataBean.getSTATUS() == 0 || dataBean.getSTATUS() == 1) {
            orderStatus = "待確認";
            statusBg.setColor(ContextCompat.getColor(getContext(), R.color.order_state0_color));
        } else if (dataBean.getSTATUS() == 2) {
            orderStatus = "待提交";
            statusBg.setColor(ContextCompat.getColor(getContext(), R.color.order_state1_color));
        } else if (dataBean.getSTATUS() == 3) {
            orderStatus = "派送中";
            statusBg.setColor(ContextCompat.getColor(getContext(), R.color.order_state2_color));
        }
        baseViewHolder.setText(R.id.tv_order_state, orderStatus);
        baseViewHolder.getView(R.id.tv_order_state).setBackground(statusBg);
    }

    private String getStatus(int curStat) {
        switch (curStat) {
            case 1:
                return "已通知物流";
            case 2:
                return "配送員已接單";
            case 3:
                return "配送員到店附近";
            case 4:
                return "配送員已到店";
            case 5:
                return "配送中";
            case 6:
                return "到達目的地附近";
            case 7:
                return "訂單已完成";
            case 8:
            case 9:
                return "物流已取消";
            case 10:
                return "已指派另一位配送員";
            default:
                return "";
        }
    }

    private void alphaAnimator(View view) {
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator ofFloat = ObjectAnimator.ofFloat(view, "alpha", 0f, 1f);
        ofFloat.setDuration(200);
        ofFloat.setRepeatCount(-1);
        ofFloat.setRepeatMode(ValueAnimator.REVERSE);

        ObjectAnimator ofFloat1 = ObjectAnimator.ofFloat(view, "alpha", 1f, 0f);
        ofFloat1.setDuration(200);
        ofFloat1.setRepeatCount(-1);
        ofFloat1.setRepeatMode(ValueAnimator.REVERSE);

        animatorSet.play(ofFloat).with(ofFloat1);
        animatorSet.setDuration(400);
        animatorSet.start();
    }
}
