package com.gingersoft.gsa.cloud.main.mvp.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.core.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.BusinessBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.BusinessInfoAdapter;
import com.gingersoft.gsa.cloud.ui.widget.BaseReloadView;

import java.util.List;

/**
 * 每日營業詳情
 */
public class DailyBusinessView extends BaseReloadView {

    private boolean isPrint = false;
    private BusinessInfoAdapter printBusinessInfoAdapter;
    private List<BusinessBean> businessBeans;

    private RecyclerView mBusinessDetails;

    public DailyBusinessView(@NonNull Context context) {
        this(context, null);
    }

    public DailyBusinessView(@NonNull Context context, boolean isPrint, List<BusinessBean> businessBeans) {
        this(context, null);
        this.isPrint = isPrint;
        this.businessBeans = businessBeans;
    }


    public DailyBusinessView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public DailyBusinessView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public boolean getDataIsNull() {
        return !isPrint && businessBeans == null;
    }

    @Override
    public ViewGroup getChildView() {
        View contentView = View.inflate(getContext(), R.layout.layout_report_daily_business_details, null);
        TextView tvTitle = contentView.findViewById(R.id.tv_daily_business_statement_title);
        TextView tvRestaurantName = contentView.findViewById(R.id.tv_restaurant_name);
        View horizontalLine = contentView.findViewById(R.id.horizontal_dividing_line);
        mBusinessDetails = contentView.findViewById(R.id.rv_business_details);
        tvRestaurantName.setText(ResturantInfoManager.newInstance().getRestaurantName());
        if (isPrint) {
            tvRestaurantName.setTextSize(24);

            tvTitle.setTextSize(30);
            horizontalLine.setBackgroundColor(ContextCompat.getColor(getContext(), R.color.black));
        }
        notifyData();
        return contentView.findViewById(R.id.layout_business_info);
    }

    @Override
    public void refreshData() {
        notifyData();
    }

    public void notifyData() {
        if (printBusinessInfoAdapter == null) {
            mBusinessDetails.setLayoutManager(new GridLayoutManager(getContext(), 3) {
                @Override
                public boolean canScrollVertically() {
                    return false;
                }
            });
            printBusinessInfoAdapter = new BusinessInfoAdapter(businessBeans, isPrint);
            mBusinessDetails.setAdapter(printBusinessInfoAdapter);
        } else {
            printBusinessInfoAdapter.setNewInstance(businessBeans);
        }
    }

    public DailyBusinessView setNewData(List<BusinessBean> businessBeans){
        this.businessBeans = businessBeans;
        notifyData();
        return this;
    }

}
