package com.gingersoft.gsa.cloud.order.order;

import com.gingersoft.gsa.cloud.common.constans.FoodSummaryConstans;
import com.gingersoft.gsa.cloud.order.cart.ShoppingCart;
import lombok.Getter;
import lombok.Setter;

/**
 * @作者: bin
 * @創建時間: 2020-10-14
 * @更新時間: 2020-10-14
 * @描述:訂單基類
 */
@Getter
@Setter
public abstract class BaseOrder {


    public BaseOrder() {
        shoppingCart = ShoppingCart.getInstance();
    }

    /**
     * 訂單類型
     *
     * @see FoodSummaryConstans#MEAL_MENU
     * @see FoodSummaryConstans#TAKEAWAY_TYPE
     */
    public volatile static int orderType = FoodSummaryConstans.RESTAURANT_MODE;
    /**
     * 訂單ID
     */
    protected long orderId = -1;
    /**
     * 訂單編號
     */
    protected String orderNo;
    /**
     * 購物車數據
     */
    protected ShoppingCart shoppingCart;


    /**
     * 判斷是否當前訂單類型
     * @param type
     * @return
     */
    public static boolean isCurrentOrderType(int type) {
        if (type == orderType) {
            return true;
        }
        return false;
    }

    /**
     * 是否在餐廳用餐
     * @return
     */
    public static boolean isTableToMeal() {
        /**
         * 餐檯模式，skyorder到餐廳用餐
         */
        if (orderType == FoodSummaryConstans.RESTAURANT_MODE || orderType == FoodSummaryConstans.SKYORDER) {
            return true;
        }
        return false;
    }


    protected void initialization() {
        orderType = FoodSummaryConstans.RESTAURANT_MODE;
        orderId = -1;
        orderNo = null;
        shoppingCart.initialization(false);
    }

}
