package com.gingersoft.gsa.cloud.pay.pos.fragment;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.constans.AppConstans;
import com.gingersoft.gsa.cloud.order.R;
import com.gingersoft.gsa.cloud.order.R2;
import com.gingersoft.gsa.cloud.pay.bean.PosActionStatusExceptionParam;
import com.gingersoft.gsa.cloud.pay.pos.OnPosActionListener;
import com.gingersoft.gsa.cloud.pay.pos.PosPay;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.request.pos.RetrievalRequest;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant.PayStatusCode;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.mvp.IView;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;

import butterknife.BindView;
import butterknife.OnClick;

/**
 * @作者: bin
 * @創建時間: 2020-12-30 10:37
 * @更新時間: 2020-12-30 10:37
 * @描述:支付狀態異常頁面，POS未回調成功的情況下顯示此頁面，重試POS查詢狀態
 */
public class PosActionStatusExceptionFragment extends BaseFragment implements IView {

    @BindView(R2.id.tv_order_num)
    TextView tvOrderNum;
    @BindView(R2.id.tv_pay_status)
    TextView tvPayStatus;
    @BindView(R2.id.pro_pay_status)
    ProgressBar proPayStatus;
    @BindView(R2.id.tv_loading_text)
    TextView tvLoadingText;
    @BindView(R2.id.tv_amount)
    TextView tvAmount;
    @BindView(R2.id.tv_paymethod)
    TextView tvPaymethod;
    @BindView(R2.id.btn_refresh_status)
    QMUIAlphaButton btnRefreshStatus;
    @BindView(R2.id.btn_back)
    QMUIAlphaButton btnBack;
    @BindView(R2.id.ll_content)
    LinearLayout llContent;
    @BindView(R2.id.rl_container)
    RelativeLayout rlContainer;


    private PosActionStatusExceptionParam mPosStatusExceptionParam;

    public static PosActionStatusExceptionFragment newInstance(PosActionStatusExceptionParam posStatusExceptionParam) {
        Bundle args = new Bundle();
        PosActionStatusExceptionFragment fragment = new PosActionStatusExceptionFragment();
        args.putParcelable("posStatusExceptionParam", posStatusExceptionParam);
        fragment.setArguments(args);
        return fragment;
    }


    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {

    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.pay_fragment_pos_status_exception, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        Bundle bundle = getArguments();
        mPosStatusExceptionParam = bundle.getParcelable("posStatusExceptionParam");

        showStatusLoading();
        initPage();
        retrievalStatus();
    }

    private void initPage() {
        tvOrderNum.setText("單號：" + mPosStatusExceptionParam.getOrderNum());
        tvAmount.setText(AppConstans.CARSH_STR + mPosStatusExceptionParam.getAmount());
        tvPaymethod.setText(mPosStatusExceptionParam.getPayMethodName());
    }

    private void showStatusLoading() {
        tvPayStatus.setVisibility(View.INVISIBLE);
        proPayStatus.setVisibility(View.VISIBLE);
        tvLoadingText.setVisibility(View.VISIBLE);
    }

    private void hideStatusLoading() {
        tvPayStatus.setVisibility(View.VISIBLE);
        proPayStatus.setVisibility(View.INVISIBLE);
        tvLoadingText.setVisibility(View.INVISIBLE);
    }

    private void retrievalStatus() {
        RetrievalRequest retrievalRequest = new RetrievalRequest();
        retrievalRequest.setTXN_ID(mPosStatusExceptionParam.getTxnId());
        PosPay.retrieval(mContext, this, retrievalRequest, new OnPosActionListener() {

            @Override
            public void onPosSuccess(HywebPosResponse response) {
                Drawable drawable;
                if (PayStatusCode.withSuccess(response.getSTATUS())) {
                    drawable = getResources().getDrawable(R.mipmap.pay_status_success);
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    tvPayStatus.setCompoundDrawables(null, drawable, null, null);
                    tvPayStatus.setText(PayStatusCode.getHywebRequestTextByCode(response.getSTATUS()));
                } else {
                    drawable = getResources().getDrawable(R.mipmap.pay_status_exception);
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                }
                tvPayStatus.setCompoundDrawables(null, drawable, null, null);
                tvPayStatus.setText(PayStatusCode.getHywebRequestTextByCode(response.getSTATUS()));
                hideStatusLoading();
            }

            @Override
            public void onPosException(HywebPosResponse response) {
                hideStatusLoading();
            }

            @Override
            public void onSuccess(HywebPosResponse response) {

            }

            @Override
            public void onError(Throwable e) {
                hideStatusLoading();
            }
        });
    }

//    private MealOrderPayRequest getMealOrderPayRequest(){
//        SaleRequest saleRequest = new SaleRequest();
//        saleRequest.setPAYMENT_APP_ID(PayMethodConstant.PAY_TYPE_CC);
//        saleRequest.setTXN_AMT(DoshokuOrder.getInstance().getShoppingCart().getTotalAmount());
//        saleRequest.setTIPS(0);
//
//        GetTxnIdRequest txnIdRequest = new GetTxnIdRequest();
//        txnIdRequest.setOrderId(DoshokuOrder.getInstance().getOrderId());
//        if (!TextUtils.isEmpty(DoshokuOrder.getInstance().getOpenTableInfo().getTableNumber())) {
//            txnIdRequest.setTableExtId(DoshokuOrder.getInstance().getOpenTableInfo().getId());
//        } else {
//            txnIdRequest.setTableId(DoshokuOrder.getInstance().getOpenTableInfo().getId());
//        }
//        txnIdRequest.setPayMethodId(hywebPayMethod.getId());
//        txnIdRequest.setAmount(hywebPayMethod.getPayMoney());
//
//        MealOrderPayRequest orderPayRequest = mPresenter.getOrderPayRequest(gsaPayView);
//        List<BillItem> billItemList = DoshokuOrder.getInstance().getShoppingCart().getBillItemList();
//    }


    @Override
    public void setData(@Nullable Object data) {

    }

    @OnClick({R2.id.btn_refresh_status, R2.id.btn_back})
    public void onViewClicked(View view) {
        int id = view.getId();
        if (id == R.id.btn_back) {
            killMyself();
        } else if (id == R.id.btn_refresh_status) {
            retrievalStatus();
        }
    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {

    }

    @Override
    public void launchActivity(@NonNull Intent intent) {

    }

    @Override
    public void killMyself() {
        _mActivity.onBackPressed();
    }
}
