package com.gingersoft.gsa.cloud.print.bean.adapter;

import com.gingersoft.gsa.cloud.common.constans.AppConstans;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.gingersoft.gsa.cloud.common.core.restaurant.ResturantInfoManager;
import com.gingersoft.gsa.cloud.common.core.settlement.SettlementReport;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.print.bean.PrintCleanMachineContent;
import com.gingersoft.gsa.cloud.print.bean.PrintContent;
import com.gingersoft.gsa.cloud.print.bean.PrintTakeawayCheckoutContent;
import com.gingersoft.gsa.cloud.print.bean.PrintTakeawayFormContent;
import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintPayTypeItem;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-01
 * @update date: 2020-12-01
 * @description:打印內容適配類，打印類拿到自身需要打印的實體信息
 */
@Data
public class PrintContentAdapter implements AdaptationContent {



    public PrintContentAdapter() {
    }

    @Override
    public PrintContent adaptationQRCode() {
        return null;
    }

    @Override
    public PrintContent adaptationPrintTakeawayCheckoutContent(OrderDetails.DataBean data) {
        return getPrintTakeawayFormContent(data, 1);
    }

    @Override
    public PrintContent adaptationPrintTakeawayFormContent(OrderDetails.DataBean data) {
        return getPrintTakeawayFormContent(data, 2);
    }

    @Override
    public PrintContent adaptationPrintCleanMachineContent(SettlementReport settlementReport) {
        PrintCleanMachineContent cleanMachineContent = new PrintCleanMachineContent();
        cleanMachineContent.setYesterdayTime(settlementReport.getYesterdayTime());
        cleanMachineContent.setVo(settlementReport.getVo());
        cleanMachineContent.setCash(settlementReport.getCash());
        cleanMachineContent.setAnalysis(settlementReport.getAnalysis());
        cleanMachineContent.setRestaurantOperationTime(TimeUtils.getStringByFormat(settlementReport.getRestaurantOperation().getOperationTime(), TimeUtils.DEFAULT_DATE_FORMAT));
        cleanMachineContent.setStartTime(settlementReport.getStartTime());
        cleanMachineContent.setCurrentTime(settlementReport.getCurrentTime());
        return cleanMachineContent;
    }

    @Override
    public PrintContent adaptationPrintSlipContent(DoshokuOrder doshokuOrder) {
        return null;
    }

    @Override
    public PrintContent adaptationServingPaperContent(DoshokuOrder doshokuOrder) {
        return null;
    }

    @Override
    public PrintContent adaptationBillContent(DoshokuOrder doshokuOrder) {
        return null;
    }

    public PrintTakeawayFormContent getPrintTakeawayFormContent(OrderDetails.DataBean data, int type) {
        PrintTakeawayFormContent takeawayPrintContent;
        if (type == 1) {
            takeawayPrintContent = new PrintTakeawayCheckoutContent();
            PrintTakeawayCheckoutContent checkoutContent = (PrintTakeawayCheckoutContent) takeawayPrintContent;
            checkoutContent.setPayTypeList(getPrintPayTypeItemsByPayMultiple(data.getPayMultiple()));
        } else {
            takeawayPrintContent = new PrintTakeawayFormContent();
        }
        takeawayPrintContent.setBrand(ResturantInfoManager.newInstance().getBrandName());
        takeawayPrintContent.setResturantName(ResturantInfoManager.newInstance().getRestaurantName());
        if (data.getOrder_type() == 2) {
            takeawayPrintContent.setOrderType("外送");
        } else {
            takeawayPrintContent.setOrderType("自取");
        }
        if (data.getPayType() == 2) {
            if (!TextUtil.isEmptyOrNullOrUndefined(data.getPayTime())) {
                //支付時間，只有在線支付有
                if (!TextUtil.isEmptyOrNullOrUndefined(data.getPayTime())) {
                    takeawayPrintContent.setPayTime("支付時間：" + data.getPayTime());
                }
            }
        }
        //取餐碼
        if (data.getOrder_type() == 7) {
            //自取  顯示 取餐碼+訂單碼
            if (!TextUtil.isEmptyOrNullOrUndefined(data.getTakeFoodCode())) {
                takeawayPrintContent.setOrderTakeFoodCode("取餐碼：" + data.getTakeFoodCode());
            }
        } else {
            //外送 顯示訂單碼
            takeawayPrintContent.setOrderTakeFoodCode("訂單碼：" + data.getTakeFoodCode());
        }
        if (data.getTakeFoodCode() == null || data.getTakeFoodCode().equals("0")) {
            takeawayPrintContent.setOrderTakeFoodCode("");
        }
        if (!TextUtil.isEmptyOrNullOrUndefined(data.getRemark())) {
            takeawayPrintContent.setRemark("備註：" + data.getRemark());
        }
        if (!TextUtil.isEmptyOrNullOrUndefined(data.getBillNo())) {
            takeawayPrintContent.setBillNo("訂單碼：" + data.getBillNo());
        }
        takeawayPrintContent.setOrderNo("單號：" + data.getORDER_NO());
        //支付類型
        takeawayPrintContent.setPayType(getPaytype(data));
        takeawayPrintContent.setDeliveryTime(data.getOrder_type() == 2 ? data.getSEND_TIME() : data.getTakeTime());
        takeawayPrintContent.setBillingTime("開單時間：" + TimeUtils.parseTimeRepeat(data.getCREATE_TIME(), TimeUtils.DEFAULT_DATE_FORMAT));
        takeawayPrintContent.setRemark("備註：" + data.getRemark());
        takeawayPrintContent.setFoodItemList(getPrintFoodItemsByProductBeans(data.getPRODUCT_NAME()));
        takeawayPrintContent.setBillItemList(getBillItemListByInfo(data.getTOTAL_AMOUNT(), data.getLunchbox(), data.getDELIVERY_CHARGE(), data.getCouponList()));
        takeawayPrintContent.setTotalAmountText("總金額: ");
        takeawayPrintContent.setTotalAmount(AppConstans.CARSH_STR + data.getTOTAL_AMOUNT());
        takeawayPrintContent.setPayAmountText("支付金額: ");
        double disCount = 0.0;
        if (data.getCouponList() != null) {
            for (OrderDetails.DataBean.CouponBean couponBean : data.getCouponList()) {
                disCount = MoneyUtil.sum(disCount, couponBean.getDiscount_amount());
            }
        }
        takeawayPrintContent.setPayAmount(AppConstans.CARSH_STR + MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), disCount));
        takeawayPrintContent.setMemberName("會員名稱: " + data.getMEMBER_NAME());
//        takeawayPrintContent.setMemberNumber(data.getm);
        takeawayPrintContent.setMemberPhone("會員電話: " + data.getPHONE());
        takeawayPrintContent.setMemberOldPoints("上次積分: " + data.getOldPoints());
        takeawayPrintContent.setMemberAddPoints("本次積分: " + data.getAddPoints());
        takeawayPrintContent.setMemberNowPoints("結餘積分: " + data.getNowPoints());
        if (data.getOrder_type() == 2) {
            //自取，隱藏地址和收貨人
//            takeawayPrintContent.setAdress("地址: " + data.getAddressDetail());
            takeawayPrintContent.setAdress(data.getAddressDetail());
            takeawayPrintContent.setReceiver("收貨人: " + data.getRECEIVER());
        }
        takeawayPrintContent.setPhone("手機號: " + data.getPHONE());
        takeawayPrintContent.setPoliteLanguage("謝謝光臨!");
        return takeawayPrintContent;
    }

    private String getPaytype(OrderDetails.DataBean data) {
        String payTypeStr = null;
        if (data.getPayType() == 1) {
            //貨到付款
            payTypeStr = "貨到付款";
        } else if (data.getPayType() == 0) {
            payTypeStr = "店內支付";
        } else if (data.getPayType() == 2) {
            if (data.getPayMultiple() != null) {
                StringBuilder payName = new StringBuilder();
                for (OrderDetails.DataBean.PayMultiple payMultiple : data.getPayMultiple()) {
                    payName.append(payMultiple.getPayName());
                    payName.append(",");
                }
                if (payName.length() > 0) {
                    payName.deleteCharAt(payName.length() - 1);
                }
                payTypeStr = "在線支付：" + payName.toString();
            } else {
                payTypeStr = "在線支付";
            }
        }
        return payTypeStr;
    }

    private List<PrintFoodItem> getPrintFoodItemsByProductBeans(List<OrderDetails.DataBean.PRODUCTNAMEBean> productnameBeanList) {
        List<OrderDetail> orderDetailList = OrderDetail.productMameBeanToOrderDetail(1, productnameBeanList);
        List<PrintFoodItem> printFoodItems = new ArrayList<>();
        for (OrderDetail orderDetail : orderDetailList) {
            printFoodItems.add(new PrintFoodItem(orderDetail.getProductName(), orderDetail.getNumber(), orderDetail.getPrice(), orderDetail.getItemType()));
        }
        return printFoodItems;
    }

    private List<PrintBillItem> getBillItemListByInfo(String totalAmount, double lunchbox, double deliveryCharge, List<OrderDetails.DataBean.CouponBean> couponBeanList) {
        List<PrintBillItem> billItems = new ArrayList<>();
        billItems.add(new PrintBillItem("合計: ", AppConstans.CARSH_STR + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(totalAmount), lunchbox), deliveryCharge)));
        if (lunchbox != 0.0) {
            billItems.add(new PrintBillItem("餐盒費: ", AppConstans.CARSH_STR + lunchbox));
        }
        if (deliveryCharge != 0.0) {
            billItems.add(new PrintBillItem("送貨費: ", AppConstans.CARSH_STR + deliveryCharge));
        }
        if (couponBeanList != null && couponBeanList.size() > 0) {
            for (OrderDetails.DataBean.CouponBean couponBean : couponBeanList) {
                billItems.add(new PrintBillItem(couponBean.getCouponName(), AppConstans.CARSH_STR + couponBean.getDiscount_amount()));
            }
        }
        return billItems;
    }

    private List<PrintPayTypeItem> getPrintPayTypeItemsByPayMultiple(List<OrderDetails.DataBean.PayMultiple> payMultiples) {
        List<PrintPayTypeItem> printPayTypeItems = new ArrayList<>();
        for (OrderDetails.DataBean.PayMultiple payMultiple : payMultiples) {
            printPayTypeItems.add(new PrintPayTypeItem(payMultiple.getPayName(), AppConstans.CARSH_STR + payMultiple.getAmount()));
        }
        return printPayTypeItems;
    }
}
