/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import com.epson.epos2.Epos2Exception;
import org.json.JSONObject;

public class FirmwareInfo {
    private String version;
    private String model;
    private String requestModel;
    private JSONObject json;

    protected FirmwareInfo(String model, String version, String requestModel) {
        this.model = model;
        this.version = version;
        this.requestModel = requestModel;
    }

    protected FirmwareInfo(String json) throws Epos2Exception {
        try {
            this.json = new JSONObject(json);
            this.version = this.json.getJSONObject("PrinterSpec").getJSONObject("Product").getString("PrinterFirmVersion");
            this.model = this.json.getJSONObject("PrinterSpec").getJSONObject("Product").getString("ProductName");
            if (this.json.getJSONObject("PrinterSpec").getJSONObject("Product").has("TypeName")) {
                this.model = this.json.getJSONObject("PrinterSpec").getJSONObject("Product").getString("TypeName");
            }
            this.requestModel = "";
        }
        catch (Exception err) {
            throw new Epos2Exception(4);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getModel() {
        return this.model;
    }

    public String getRequestModel() {
        return this.requestModel;
    }

    protected JSONObject getJson() {
        return this.json;
    }

    protected void setVersion(String version) {
        this.version = version;
    }
}

