/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice.scanner;

import com.epson.eposdevice.scanner.DataListener;
import com.epson.eposdevice.scanner.NativeScanner;

public abstract class Scanner
extends NativeScanner {
    private DataListener mDataListener = null;
    private long mScanHandle = 0L;

    private void OnScanData(String ipAddress, String deviceId, String input) {
        if (null != this.mDataListener) {
            this.outputLogEvent("onScanData", ipAddress, deviceId, input);
            this.mDataListener.onScanData(ipAddress, deviceId, input);
        }
    }

    protected Scanner(long scanHandle) {
        this.mScanHandle = scanHandle;
    }

    protected long getInnerHandle() {
        return this.mScanHandle;
    }

    protected void innerDeleteInstance() {
        this.nativeSetScanDataCallback(this.mScanHandle, null);
        this.mScanHandle = 0L;
    }

    public void setDataEventCallback(DataListener target) {
        if (this.mScanHandle != 0L) {
            if (target != null) {
                this.mDataListener = target;
                this.nativeSetScanDataCallback(this.mScanHandle, this);
            } else {
                this.nativeSetScanDataCallback(this.mScanHandle, null);
                this.mDataListener = null;
            }
        }
    }

    @Override
    protected void nativeOnScanData(String ipAddress, String deviceId, String input) {
        this.OnScanData(ipAddress, deviceId, input);
    }

    protected abstract void outputLogCallFunction(String var1, Object ... var2);

    protected abstract void outputLogReturnFunction(String var1, Object ... var2);

    protected abstract void outputException(String var1, Exception var2);

    protected abstract void outputLogEvent(String var1, Object ... var2);
}

