package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "PRINTER_DEVICE_BEAN".
*/
public class PrinterDeviceBeanDao extends AbstractDao<PrinterDeviceBean, Long> {

    public static final String TABLENAME = "PRINTER_DEVICE_BEAN";

    /**
     * Properties of entity PrinterDeviceBean.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Id = new Property(0, Long.class, "id", false, "ID");
        public final static Property Dbid = new Property(1, Long.class, "dbid", true, "_id");
        public final static Property Name = new Property(2, String.class, "name", false, "NAME");
        public final static Property RestaurantId = new Property(3, Integer.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property Ip = new Property(4, String.class, "ip", false, "IP");
        public final static Property Uid = new Property(5, Long.class, "uid", false, "UID");
        public final static Property Port = new Property(6, Integer.class, "port", false, "PORT");
        public final static Property Type = new Property(7, Integer.class, "type", false, "TYPE");
        public final static Property PrinterModelId = new Property(8, Long.class, "printerModelId", false, "PRINTER_MODEL_ID");
        public final static Property PaperSpecification = new Property(9, String.class, "paperSpecification", false, "PAPER_SPECIFICATION");
        public final static Property PrinterName = new Property(10, String.class, "printerName", false, "PRINTER_NAME");
        public final static Property Model = new Property(11, String.class, "model", false, "MODEL");
        public final static Property NoteContent = new Property(12, String.class, "noteContent", false, "NOTE_CONTENT");
        public final static Property PrinterDeviceDefaultId = new Property(13, Long.class, "printerDeviceDefaultId", false, "PRINTER_DEVICE_DEFAULT_ID");
        public final static Property FlyPrinterDeviceId = new Property(14, Long.class, "flyPrinterDeviceId", false, "FLY_PRINTER_DEVICE_ID");
        public final static Property FlyPrinterDeviceId2 = new Property(15, Long.class, "flyPrinterDeviceId2", false, "FLY_PRINTER_DEVICE_ID2");
        public final static Property FoodIsBold = new Property(16, int.class, "foodIsBold", false, "FOOD_IS_BOLD");
        public final static Property FoodFont = new Property(17, String.class, "foodFont", false, "FOOD_FONT");
        public final static Property FoodIsItalic = new Property(18, int.class, "foodIsItalic", false, "FOOD_IS_ITALIC");
        public final static Property ModifierIsBold = new Property(19, int.class, "modifierIsBold", false, "MODIFIER_IS_BOLD");
        public final static Property ModifierFont = new Property(20, String.class, "modifierFont", false, "MODIFIER_FONT");
        public final static Property ModifierIsItalic = new Property(21, int.class, "modifierIsItalic", false, "MODIFIER_IS_ITALIC");
        public final static Property NumberIsFlip = new Property(22, int.class, "numberIsFlip", false, "NUMBER_IS_FLIP");
    }


    public PrinterDeviceBeanDao(DaoConfig config) {
        super(config);
    }
    
    public PrinterDeviceBeanDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"PRINTER_DEVICE_BEAN\" (" + //
                "\"ID\" INTEGER," + // 0: id
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 1: dbid
                "\"NAME\" TEXT," + // 2: name
                "\"RESTAURANT_ID\" INTEGER," + // 3: restaurantId
                "\"IP\" TEXT," + // 4: ip
                "\"UID\" INTEGER," + // 5: uid
                "\"PORT\" INTEGER," + // 6: port
                "\"TYPE\" INTEGER," + // 7: type
                "\"PRINTER_MODEL_ID\" INTEGER," + // 8: printerModelId
                "\"PAPER_SPECIFICATION\" TEXT," + // 9: paperSpecification
                "\"PRINTER_NAME\" TEXT," + // 10: printerName
                "\"MODEL\" TEXT," + // 11: model
                "\"NOTE_CONTENT\" TEXT," + // 12: noteContent
                "\"PRINTER_DEVICE_DEFAULT_ID\" INTEGER," + // 13: printerDeviceDefaultId
                "\"FLY_PRINTER_DEVICE_ID\" INTEGER," + // 14: flyPrinterDeviceId
                "\"FLY_PRINTER_DEVICE_ID2\" INTEGER," + // 15: flyPrinterDeviceId2
                "\"FOOD_IS_BOLD\" INTEGER NOT NULL ," + // 16: foodIsBold
                "\"FOOD_FONT\" TEXT," + // 17: foodFont
                "\"FOOD_IS_ITALIC\" INTEGER NOT NULL ," + // 18: foodIsItalic
                "\"MODIFIER_IS_BOLD\" INTEGER NOT NULL ," + // 19: modifierIsBold
                "\"MODIFIER_FONT\" TEXT," + // 20: modifierFont
                "\"MODIFIER_IS_ITALIC\" INTEGER NOT NULL ," + // 21: modifierIsItalic
                "\"NUMBER_IS_FLIP\" INTEGER NOT NULL );"); // 22: numberIsFlip
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"PRINTER_DEVICE_BEAN\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, PrinterDeviceBean entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(2, dbid);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String ip = entity.getIp();
        if (ip != null) {
            stmt.bindString(5, ip);
        }
 
        Long uid = entity.getUid();
        if (uid != null) {
            stmt.bindLong(6, uid);
        }
 
        Integer port = entity.getPort();
        if (port != null) {
            stmt.bindLong(7, port);
        }
 
        Integer type = entity.getType();
        if (type != null) {
            stmt.bindLong(8, type);
        }
 
        Long printerModelId = entity.getPrinterModelId();
        if (printerModelId != null) {
            stmt.bindLong(9, printerModelId);
        }
 
        String paperSpecification = entity.getPaperSpecification();
        if (paperSpecification != null) {
            stmt.bindString(10, paperSpecification);
        }
 
        String printerName = entity.getPrinterName();
        if (printerName != null) {
            stmt.bindString(11, printerName);
        }
 
        String model = entity.getModel();
        if (model != null) {
            stmt.bindString(12, model);
        }
 
        String noteContent = entity.getNoteContent();
        if (noteContent != null) {
            stmt.bindString(13, noteContent);
        }
 
        Long printerDeviceDefaultId = entity.getPrinterDeviceDefaultId();
        if (printerDeviceDefaultId != null) {
            stmt.bindLong(14, printerDeviceDefaultId);
        }
 
        Long flyPrinterDeviceId = entity.getFlyPrinterDeviceId();
        if (flyPrinterDeviceId != null) {
            stmt.bindLong(15, flyPrinterDeviceId);
        }
 
        Long flyPrinterDeviceId2 = entity.getFlyPrinterDeviceId2();
        if (flyPrinterDeviceId2 != null) {
            stmt.bindLong(16, flyPrinterDeviceId2);
        }
        stmt.bindLong(17, entity.getFoodIsBold());
 
        String foodFont = entity.getFoodFont();
        if (foodFont != null) {
            stmt.bindString(18, foodFont);
        }
        stmt.bindLong(19, entity.getFoodIsItalic());
        stmt.bindLong(20, entity.getModifierIsBold());
 
        String modifierFont = entity.getModifierFont();
        if (modifierFont != null) {
            stmt.bindString(21, modifierFont);
        }
        stmt.bindLong(22, entity.getModifierIsItalic());
        stmt.bindLong(23, entity.getNumberIsFlip());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, PrinterDeviceBean entity) {
        stmt.clearBindings();
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(1, id);
        }
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(2, dbid);
        }
 
        String name = entity.getName();
        if (name != null) {
            stmt.bindString(3, name);
        }
 
        Integer restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String ip = entity.getIp();
        if (ip != null) {
            stmt.bindString(5, ip);
        }
 
        Long uid = entity.getUid();
        if (uid != null) {
            stmt.bindLong(6, uid);
        }
 
        Integer port = entity.getPort();
        if (port != null) {
            stmt.bindLong(7, port);
        }
 
        Integer type = entity.getType();
        if (type != null) {
            stmt.bindLong(8, type);
        }
 
        Long printerModelId = entity.getPrinterModelId();
        if (printerModelId != null) {
            stmt.bindLong(9, printerModelId);
        }
 
        String paperSpecification = entity.getPaperSpecification();
        if (paperSpecification != null) {
            stmt.bindString(10, paperSpecification);
        }
 
        String printerName = entity.getPrinterName();
        if (printerName != null) {
            stmt.bindString(11, printerName);
        }
 
        String model = entity.getModel();
        if (model != null) {
            stmt.bindString(12, model);
        }
 
        String noteContent = entity.getNoteContent();
        if (noteContent != null) {
            stmt.bindString(13, noteContent);
        }
 
        Long printerDeviceDefaultId = entity.getPrinterDeviceDefaultId();
        if (printerDeviceDefaultId != null) {
            stmt.bindLong(14, printerDeviceDefaultId);
        }
 
        Long flyPrinterDeviceId = entity.getFlyPrinterDeviceId();
        if (flyPrinterDeviceId != null) {
            stmt.bindLong(15, flyPrinterDeviceId);
        }
 
        Long flyPrinterDeviceId2 = entity.getFlyPrinterDeviceId2();
        if (flyPrinterDeviceId2 != null) {
            stmt.bindLong(16, flyPrinterDeviceId2);
        }
        stmt.bindLong(17, entity.getFoodIsBold());
 
        String foodFont = entity.getFoodFont();
        if (foodFont != null) {
            stmt.bindString(18, foodFont);
        }
        stmt.bindLong(19, entity.getFoodIsItalic());
        stmt.bindLong(20, entity.getModifierIsBold());
 
        String modifierFont = entity.getModifierFont();
        if (modifierFont != null) {
            stmt.bindString(21, modifierFont);
        }
        stmt.bindLong(22, entity.getModifierIsItalic());
        stmt.bindLong(23, entity.getNumberIsFlip());
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1);
    }    

    @Override
    public PrinterDeviceBean readEntity(Cursor cursor, int offset) {
        PrinterDeviceBean entity = new PrinterDeviceBean( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // id
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // dbid
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // name
            cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3), // restaurantId
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // ip
            cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5), // uid
            cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6), // port
            cursor.isNull(offset + 7) ? null : cursor.getInt(offset + 7), // type
            cursor.isNull(offset + 8) ? null : cursor.getLong(offset + 8), // printerModelId
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // paperSpecification
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // printerName
            cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11), // model
            cursor.isNull(offset + 12) ? null : cursor.getString(offset + 12), // noteContent
            cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13), // printerDeviceDefaultId
            cursor.isNull(offset + 14) ? null : cursor.getLong(offset + 14), // flyPrinterDeviceId
            cursor.isNull(offset + 15) ? null : cursor.getLong(offset + 15), // flyPrinterDeviceId2
            cursor.getInt(offset + 16), // foodIsBold
            cursor.isNull(offset + 17) ? null : cursor.getString(offset + 17), // foodFont
            cursor.getInt(offset + 18), // foodIsItalic
            cursor.getInt(offset + 19), // modifierIsBold
            cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20), // modifierFont
            cursor.getInt(offset + 21), // modifierIsItalic
            cursor.getInt(offset + 22) // numberIsFlip
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, PrinterDeviceBean entity, int offset) {
        entity.setId(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setDbid(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setName(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setRestaurantId(cursor.isNull(offset + 3) ? null : cursor.getInt(offset + 3));
        entity.setIp(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setUid(cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5));
        entity.setPort(cursor.isNull(offset + 6) ? null : cursor.getInt(offset + 6));
        entity.setType(cursor.isNull(offset + 7) ? null : cursor.getInt(offset + 7));
        entity.setPrinterModelId(cursor.isNull(offset + 8) ? null : cursor.getLong(offset + 8));
        entity.setPaperSpecification(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setPrinterName(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setModel(cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11));
        entity.setNoteContent(cursor.isNull(offset + 12) ? null : cursor.getString(offset + 12));
        entity.setPrinterDeviceDefaultId(cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13));
        entity.setFlyPrinterDeviceId(cursor.isNull(offset + 14) ? null : cursor.getLong(offset + 14));
        entity.setFlyPrinterDeviceId2(cursor.isNull(offset + 15) ? null : cursor.getLong(offset + 15));
        entity.setFoodIsBold(cursor.getInt(offset + 16));
        entity.setFoodFont(cursor.isNull(offset + 17) ? null : cursor.getString(offset + 17));
        entity.setFoodIsItalic(cursor.getInt(offset + 18));
        entity.setModifierIsBold(cursor.getInt(offset + 19));
        entity.setModifierFont(cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20));
        entity.setModifierIsItalic(cursor.getInt(offset + 21));
        entity.setNumberIsFlip(cursor.getInt(offset + 22));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(PrinterDeviceBean entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(PrinterDeviceBean entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(PrinterDeviceBean entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
