package com.joe.print.mvp.model.bean;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import java.util.ArrayList;
import java.util.List;

public class PrintInfoBean {

    //數組多長就有多少列
    private String[] content;
    //private int[] widght;//每列佔比權重

    private Boolean[] isBold = new Boolean[]{false};

    private Boolean[] isItalic = new Boolean[]{false};

    private int[] color = new int[]{0};

    private double[] size = new double[]{1};

    //語言，每列是什麼語言
    private String[] Language = new String[]{"tw"};
    //content數量為1時才生效，默認居中
    private int gravity = 1;

    public PrintInfoBean(String[] content) {
        this.content = content;
    }

    public PrintInfoBean(String[] content, String[] language) {
        this.content = content;
        Language = language;
    }

    public PrintInfoBean(String[] content, double[] size) {
        this.content = content;
        this.size = size;
    }

    public PrintInfoBean(String[] content, double[] size, String[] language) {
        this.content = content;
        this.size = size;
        Language = language;
    }


    public PrintInfoBean(String[] content, int gravity) {
        this.content = content;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold) {
        this.content = content;
        this.isBold = isBold;
    }

    public PrintInfoBean(String[] content, double[] size, int gravity) {
        this.content = content;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, int[] color, double[] size, int gravity) {
        this.content = content;
        this.color = color;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, double[] size) {
        this.content = content;
        this.isBold = isBold;
        this.size = size;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, double[] size, String[] language) {
        this.content = content;
        this.isBold = isBold;
        this.size = size;
        Language = language;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, double[] size, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, int[] color, double[] size, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.color = color;
        this.size = size;
        this.gravity = gravity;
    }

    public PrintInfoBean(String[] content, Boolean[] isBold, Boolean[] isItalic, int[] color, double[] size, int gravity) {
        this.content = content;
        this.isBold = isBold;
        this.isItalic = isItalic;
        this.color = color;
        this.size = size;
        this.gravity = gravity;
    }

    public String[] getContent() {
        return content;
    }

    public void setContent(String[] content) {
        this.content = content;
    }

    public Boolean[] getIsBold() {
        return isBold;
    }

    public void setIsBold(Boolean[] isBold) {
        this.isBold = isBold;
    }

    public Boolean[] getIsItalic() {
        return isItalic;
    }

    public void setIsItalic(Boolean[] isItalic) {
        this.isItalic = isItalic;
    }

    public int[] getColor() {
        return color;
    }

    public void setColor(int[] color) {
        this.color = color;
    }

    public double[] getSize() {
        return size;
    }

    public void setSize(double[] size) {
        this.size = size;
    }

    public int getGravity() {
        return gravity;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
    }

    public String[] getLanguage() {
        return Language;
    }

    public void setLanguage(String[] language) {
        Language = language;
    }

    public static List<List<PrintInfoBean>> transPrjBean(List<PrjBean.DataBean.Bean> datas, int paperWidth, String printLocation, PrinterDeviceBean deviceBean, PrintCurrencyBean printCurrencyBean) {
        List<List<PrintInfoBean>> prjPrintBeans = new ArrayList<>();
        //通過打印位置生成多張用於打印的bitmap
        for (PrjBean.DataBean.Bean prjbean : datas) {
            List<PrjBean.DataBean.Bean> noCut = new ArrayList<>();
            //遍歷當前打印位置所有的食品
            if (prjbean.getStatus() == 2) {
                //切紙，單獨生成一條prj數據
                List<PrjBean.DataBean.Bean> beans = new ArrayList<>();
                beans.add(prjbean);
                prjPrintBeans.add(getPrjPrintInfoBean(printLocation, paperWidth, beans, deviceBean, printCurrencyBean));
            } else {
                //不切紙，保存到單獨的集合里，之後生成一組數據
                noCut.add(prjbean);
            }
            if (noCut.size() > 0) {
                prjPrintBeans.add(getPrjPrintInfoBean(printLocation, paperWidth, noCut, deviceBean, printCurrencyBean));
            }
        }
        return prjPrintBeans;
    }

    /**
     * 生成一張prj打印數據
     *
     * @return
     */
    private static List<PrintInfoBean> getPrjPrintInfoBean(String key, int peparWidth, List<PrjBean.DataBean.Bean> prjBeans, PrinterDeviceBean deviceBean, PrintCurrencyBean printCurrencyBean) {
        List<PrintInfoBean> printInfoBeans = new ArrayList<>();
        boolean foodIsBold = false;//食品是否加粗
        boolean foodItemIsBolde = false;//細項是否加粗
        boolean foodIsItalic = false;//食品是否斜體
        boolean modifierIsItalic = false;//細項是否斜體
        boolean numberIsFlip = false;//數量大於1顏色是否翻轉
        int foodColor = 0;//食品顏色
        int modifierColor = 0;//細項顏色

        if (printCurrencyBean != null) {
            foodColor = printCurrencyBean.getFoodComplexion();
            modifierColor = printCurrencyBean.getModifierComplexion();
        }

        if (deviceBean.getFoodIsBold() == 1) {
            foodIsBold = true;
        } else if (printCurrencyBean != null) {
            foodIsBold = printCurrencyBean.getFoodIsBold() == 1;
        }

        if (deviceBean.getModifierIsBold() == 1) {
            foodItemIsBolde = true;
        } else if (printCurrencyBean != null) {
            foodItemIsBolde = printCurrencyBean.getModifierIsBold() == 1;
        }

        if (deviceBean.getFoodIsItalic() == 1) {
            foodIsItalic = true;
        } else if (printCurrencyBean != null) {
            foodIsItalic = printCurrencyBean.getFoodIsItalic() == 1;
        }
        if (deviceBean.getModifierIsItalic() == 1) {
            modifierIsItalic = true;
        } else if (printCurrencyBean != null) {
            modifierIsItalic = printCurrencyBean.getModifierIsItalic() == 1;
        }

        if (deviceBean.getNumberIsFlip() == 1) {
            numberIsFlip = true;
        } else if (printCurrencyBean != null) {
            numberIsFlip = printCurrencyBean.getNumberIsFlip() == 1;
        }


        if (prjBeans == null || prjBeans.size() <= 0) {
            return null;
        }
        PrjBean.DataBean.Bean prjBean = prjBeans.get(0);
        if (prjBean == null) {
            return null;
        }
        if (TextUtil.isEmptyOrNullOrUndefined(prjBean.getTableName())) {
            if (prjBean.getOrderType() == 7) {
                printInfoBeans.add(new PrintInfoBean(new String[]{"自取"}, new Boolean[]{true}, new double[]{2}, 0));
                if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getTakeFoodCode())) {
                    printInfoBeans.add(new PrintInfoBean(new String[]{"取餐碼：", prjBean.getTakeFoodCode()}, new Boolean[]{false, true}, new double[]{1, 2}, 0));
                }
                if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getBillNo())) {
                    //訂單碼不為空
                    printInfoBeans.add(new PrintInfoBean(new String[]{"訂單碼：", prjBean.getBillNo()}, new Boolean[]{false, true}, new double[]{1, 2}, 0));
                }
            } else {
                printInfoBeans.add(new PrintInfoBean(new String[]{"外賣"}, new Boolean[]{true}, new double[]{2}, 0));
                if (!TextUtil.isEmptyOrNullOrUndefined(prjBean.getBillNo())) {
                    //訂單碼不為空
                    printInfoBeans.add(new PrintInfoBean(new String[]{"訂單碼：", prjBean.getBillNo()}, new Boolean[]{false, true}, new double[]{1, 2}, 0));
                }
            }
        } else {
            printInfoBeans.add(new PrintInfoBean(new String[]{prjBean.getTableName()}, new Boolean[]{true}, new double[]{2}, 0));
        }
        //落單時間
        printInfoBeans.add(new PrintInfoBean(new String[]{"落單時間：" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_MDHM)}, new double[]{1}, 0));
        //廚房位置
        if (!TextUtil.isEmptyOrNullOrUndefined(key) && !key.equals("-1")) {
            printInfoBeans.add(new PrintInfoBean(new String[]{key + "廚房", " " + GsaCloudApplication.getMemberName(GsaCloudApplication.getAppContext())}, new double[]{1}, 0));
        }
        //人數
        if (prjBean.getPerson() != 0) {
            printInfoBeans.add(new PrintInfoBean(new String[]{"人數：" + prjBean.getPerson(), GsaCloudApplication.getMemberName(GsaCloudApplication.getAppContext())}, new double[]{1}, 0));
        }
        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("", 1, peparWidth)}, 0));
        for (PrjBean.DataBean.Bean bean : prjBeans) {
            if (bean.getParentId() == 0) {
                //沒有父級id，則是第一級食品
                bean.setItemType(1);
            }
            //如果父級id不為0，是細項
            if (bean.getParentId() != 0) {
                bean.setItemType(2);//先設置為細項，再通過下面的遍歷確定是否是第三級細項
                //循環遍歷查找父級食品
                for (PrjBean.DataBean.Bean itembean : prjBeans) {
                    if (bean.getParentId() == itembean.getOrderDetailsId()) {
                        //如果父級是細項，則當前食品就是二級細項
                        bean.setItemType(bean.getItemType() + 1);
                        break;
                    }
                }
            }
            int beforeColor = 0;
            if (bean.getItemType() == 1) {
                //如果是主食品
                beforeColor = foodColor;
            } else {
                //細項
                beforeColor = modifierColor;
            }
            if (bean.getNumber() > 1 && numberIsFlip) {
                //翻轉顏色
                if(beforeColor == 0){
                    beforeColor = 2;
                } else {
                    beforeColor = 0;
                }
            }
            if (bean.getItemType() == 1) {
                //主食品
                printInfoBeans.add(new PrintInfoBean(new String[]{bean.getNumber() + " ", bean.getProductName()}, new Boolean[]{foodIsBold}, new Boolean[]{foodIsItalic}, new int[]{beforeColor}, new double[]{2}, 0));
            } else if (bean.getItemType() == 2) {
                //細項
                printInfoBeans.add(new PrintInfoBean(new String[]{bean.getNumber() + " ", " " + bean.getProductName()}, new Boolean[]{foodItemIsBolde}, new Boolean[]{modifierIsItalic}, new int[]{beforeColor}, new double[]{2}, 0));
            } else if (bean.getItemType() == 3) {
                //二級細項
                printInfoBeans.add(new PrintInfoBean(new String[]{bean.getNumber() + " ", "  " + bean.getProductName()}, new Boolean[]{foodItemIsBolde}, new Boolean[]{modifierIsItalic}, new int[]{beforeColor}, new double[]{2}, 0));
            }
        }
        PrintInfoBean printInfoBean = printInfoBeans.get(0);
        printInfoBean.setGravity(1);
        printInfoBeans.add(printInfoBean);
        return printInfoBeans;
    }

    private static String getLineBorder(String text, double fontSize, int paperWidth) {
        if (fontSize == 0) {
            fontSize = 1;
        }
        //中文字符個數，Epson打印機每個中文字符佔1.5格
        double cnCount = getChineseValueLength(text);
        int count = (int) Math.floor(((paperWidth / fontSize) - cnCount));
        if (count <= 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count / 2; i++) {
            builder.append("-");
        }
        builder.append(text);
        for (int i = 0; i < count / 2; i++) {
            builder.append("-");
        }
        return builder.toString();
    }

    private static double getChineseValueLength(String value) {
        double valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 1.5;
            } else {
                valueLength += 1;
            }
        }
        return valueLength;
    }

}
