package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.base.adapter.print.BillAdapter;
import com.gingersoft.gsa.cloud.base.adapter.print.FoodAdapter;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.BillingBean;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.joe.print.R;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 上菜紙打印
 */
public class PrintServe extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getServeBitmap(mContext));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    /**
     * 獲取"印單"圖片
     *
     * @param context
     * @return
     */
    private Bitmap getServeBitmap(Context context) {
        List<OrderDetail> foodList = MyOrderManage.getInstance().getNewFoodList();
        if (foodList == null || foodList.size() <= 0) {
            return null;
        }
        View view = LinearLayout.inflate(context, R.layout.print_layout_print, null);
        TextView brandName = view.findViewById(R.id.tv_brand_name);
        TextView restaurantName = view.findViewById(R.id.tv_restaurant_name);
        TextView tableNum = view.findViewById(R.id.tv_dining_table_number);
        TextView people = view.findViewById(R.id.tv_people);
        TextView orderNum = view.findViewById(R.id.tv_order_num);
        TextView orderData = view.findViewById(R.id.tv_date);
        RecyclerView rvFood = view.findViewById(R.id.rv_food);
        RecyclerView rvBillAmount = view.findViewById(R.id.rv_bill_amount);
        TextView mTvTotalAmount = view.findViewById(R.id.tv_total_amount);
        TextView checkOutTime = view.findViewById(R.id.tv_checkout_time);
        TextView line_food_info = view.findViewById(R.id.line_food_info);
        TableBean.DataBean tableBean = OpenTableManage.getDefault().getTableBean();
        brandName.setText(GsaCloudApplication.getBrandName(context));
        restaurantName.setText(GsaCloudApplication.getRestaurantName(context));
        tableNum.setText("餐檯：" + tableBean.getTableName());
        people.setText("人數：" + OpenTableManage.getDefault().getPeopleNumber());

        orderData.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT));

        checkOutTime.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT));
        FoodAdapter foodAdapter = new FoodAdapter(foodList);
        rvFood.setLayoutManager(new LinearLayoutManager(context));
        rvFood.setAdapter(foodAdapter);

        List<BillingBean> billingBeans = new ArrayList<>();
//        if (billingBeans.size() <= 0) {
        line_food_info.setVisibility(View.GONE);
        rvBillAmount.setVisibility(View.GONE);
        view.findViewById(R.id.line_price_info).setVisibility(View.GONE);
//        } else {
//            BillAdapter billAdapter = new BillAdapter(billingBeans);
//            rvBillAmount.setLayoutManager(new LinearLayoutManager(context));
//            rvBillAmount.setAdapter(billAdapter);
//        }
        if (OpenTableManage.getDefault().getTableBean() != null) {
            tableNum.setText(OpenTableManage.getDefault().getTableBean().getTableName());
            people.setText(OpenTableManage.getDefault().getPeopleNumber() + "");
        }

        if (MyOrderManage.getInstance().getOrderId() != -1) {
            orderNum.setText(MyOrderManage.getInstance().getOrderId() + "");
        }

//        BigDecimal totalAmount = new BigDecimal(0);
//        for (OrderDetail OrderDetail : foodList) {
//            totalAmount = MoneyUtil.sum(totalAmount, MoneyUtil.priceCalculation(OrderDetail.getPrice(), OrderDetail.getNumber()));
//        }
        //總金額
        view.findViewById(R.id.tv_total_amount_text).setVisibility(View.GONE);
        mTvTotalAmount.setVisibility(View.GONE);
        mTvTotalAmount.setText(MyOrderManage.getInstance().getTotalAmount() + "");
        //加载条形码
//        ImageView ivBarCode = view.findViewById(R.id.iv_bar_code);
//        ivBarCode.setImageBitmap(BitmapUtil.generateBitmap("12312112131", 2, 450, 150));
        return viewToBitmap(context, view);
    }
}
