package com.joe.print.mvp.print.utils;

import android.content.Context;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.database.utils.PrintCurrencyDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.PrinterDeviceDaoUtils;
import com.joe.print.R;

import java.util.List;

public class MyPrintUtils {

    private final int HEADER_TEXTSIZE = 26;

    private static MyPrintUtils myPrintUtils;

    public static MyPrintUtils getInstance() {
        if (myPrintUtils == null) {
            myPrintUtils = new MyPrintUtils();
        }
        return myPrintUtils;
    }


    /**
     * 通過類型獲取打印通用配置
     *
     * @param context
     * @param type    1：堂食，2：外送
     * @return
     */
    public PrintCurrencyBean getPrintCurrencyBeanByType(Context context, int type) {
        PrintCurrencyDaoUtils printCurrencyDaoUtils = new PrintCurrencyDaoUtils(context);
        List<PrintCurrencyBean> printCurrencyBeans = printCurrencyDaoUtils.queryAllPrintCurrencyBean();
        for (PrintCurrencyBean printCurrencyBean : printCurrencyBeans) {
            if (printCurrencyBean.getType() == type) {
                return printCurrencyBean;
            }
        }
        return null;
    }


    /**
     * 通過打印位置獲取打印機
     *
     * @param context
     * @param printerDeviceName 打印機名稱：打印機位置
     * @return
     */
    public PrinterDeviceBean getPrinterDeviceByLocation(Context context, String printerDeviceName) {
        PrinterDeviceDaoUtils printerDeviceDaoUtils = new PrinterDeviceDaoUtils(context);
        List<PrinterDeviceBean> printerDeviceBeans = printerDeviceDaoUtils.queryAllPrinterDeviceBean();
        if (printerDeviceBeans != null && printerDeviceBeans.size() > 0) {
            for (PrinterDeviceBean printerDevice : printerDeviceBeans) {
                if (printerDevice.getName() != null && printerDevice.getName().equals(printerDeviceName)) {
                    return printerDevice;
                }
            }
        }
        printerDeviceDaoUtils.closeConnection();
        return null;
    }

    /**
     * 獲取默認打印機
     *
     * @param context
     * @return
     */
    public PrinterDeviceBean getDefaultPrinterDevice(Context context) {
        PrinterDeviceDaoUtils printerDeviceDaoUtils = new PrinterDeviceDaoUtils(context);
        List<PrinterDeviceBean> printerDeviceBeans = printerDeviceDaoUtils.queryAllPrinterDeviceBean();
        if (printerDeviceBeans != null && printerDeviceBeans.size() > 0) {
            for (PrinterDeviceBean printerDevice : printerDeviceBeans) {
                if (printerDevice.getPrinterDeviceDefaultId() != null) {
                    return printerDevice;
                }
            }
        }
        printerDeviceDaoUtils.closeConnection();
        return null;
    }


    public TextView getBrandName(Context context) {
        return getNormalTextView(context, GsaCloudApplication.getBrandName(context), HEADER_TEXTSIZE);
    }

    public TextView getRestaurantName(Context context) {
        return getNormalTextView(context, GsaCloudApplication.getRestaurantName(context), HEADER_TEXTSIZE);
    }

    public TextView getDashedLine(Context context) {
        TextView textView = getNormalTextView(context, context.getString(R.string.print_split_line), HEADER_TEXTSIZE);
        textView.setSingleLine(true);
        return textView;
    }

    public TextView getNormalTextView(Context context, String text, int textSize) {
        TextView textView = new TextView(context);
        textView.setText(text);
        textView.setTextSize(textSize);
        return textView;
    }


}
