package com.joe.print.mvp.ui.activity;

import android.os.Bundle;

import androidx.appcompat.app.AppCompatActivity;

import com.epson.epos2.printer.PrinterStatusInfo;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.PrintExecutor;
import com.gingersoft.gsa.cloud.print.PrintSocketHolder;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.PrintInfoBean;
import com.joe.print.mvp.print.EpsonPrint;

import java.util.ArrayList;
import java.util.List;

public class PrintTestActivity extends AppCompatActivity implements PrintSocketHolder.OnStateChangedListener, PrintExecutor.OnPrintResultListener {

    private int lineLength = 24;//一行42個
    private int LEFT_TEXT_LENGTH = 8;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_print_test);

        PrinterDeviceBean printerDeviceBean = new PrinterDeviceBean("192.168.1.218", 9100, "400");
        List<PrintInfoBean> printInfoBeans = new ArrayList<>();
//        printInfoBeans.add(new PrintInfoBean(new String[]{"測試一行多少個字測試一行多少個字測試一"}, new double[]{2}, new String[]{"tw"}));
//        printInfoBeans.add(new PrintInfoBean(new String[]{"asdfskjflsjflsjlfjslfjsldjflsjfsd"}, new double[]{2}, new String[]{"tw"}));
//        printInfoBeans.add(new PrintInfoBean(new String[]{"測試一行多少個字測試一行多少個字測試一"}, new double[]{1}, new String[]{"tw"}));
//        printInfoBeans.add(new PrintInfoBean(new String[]{"asdfskjflsjflsjlfjslfjsldjflsjfsd"}, new double[]{1}, new String[]{"tw"}));
        //        printInfoBeans.add(new PrintInfoBean(new String[]{"純屬餐廳"}, new double[]{1}, new String[]{"tw"}));

        printInfoBeans.add(new PrintInfoBean(new String[]{"外賣"}, new Boolean[]{true}, new double[]{2}, 0));
        printInfoBeans.add(new PrintInfoBean(new String[]{"訂單碼：", "0046"}, new Boolean[]{false, true}, new double[]{1, 2}, 0));
        printInfoBeans.add(new PrintInfoBean(new String[]{"落單時間：", "07-13 19:05"}, new double[]{1}, 0));
        printInfoBeans.add(new PrintInfoBean(new String[]{"D1廚房", "BARRY1"}, new double[]{1}, 0));
        printInfoBeans.add(new PrintInfoBean(new String[]{getLineBorder("", 1)}, 0));
        printInfoBeans.add(new PrintInfoBean(new String[]{"1","食品名稱"}, new Boolean[]{true}, new double[]{2}, 0));
        printInfoBeans.add(new PrintInfoBean(new String[]{"1","  細項名稱"}, new Boolean[]{true}, new double[]{2}, 0));
        printInfoBeans.add(new PrintInfoBean(new String[]{"外賣"}, new Boolean[]{true}, new double[]{2}, 1));

        findViewById(R.id.btn_test).setOnClickListener(view -> {
            //打印測試
//            PrintExecutor executor = new PrintExecutor(printerDeviceBean);
//            executor.setOnStateChangedListener(this);
//            executor.setOnPrintResultListener(this);
//
//            TestPrintMaker maker = null;
//            try {
//                maker = new TestPrintMaker(new PrinterWriter80mm(255), printInfoBeans);
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//            executor.doPrinterRequestAsync(maker);

            EpsonPrint mPrinter = EpsonPrint.getInstance();
            PrinterStatusInfo status = mPrinter.getStatus();
            if (status != null && status.getPaper() == 2) {
                ToastUtils.show(this, "缺紙了");
            }
            mPrinter.initializeObject(GsaCloudApplication.getAppContext(), null);
            mPrinter.putPrintString("192.168.1.203", 42, printInfoBeans);

//            new Thread(() -> {
//                for (int j = 0; j < finalZoomBitmap.size(); j++) {
//                    mPrinter.putPrintData(printerDeviceBean.getIp(), finalZoomBitmap.get(j));
//                }
//            }).start();
        });
    }

    @Override
    public void onResult(int errorCode, PrinterDeviceBean printerDeviceBean) {

    }

    @Override
    public void onStateChanged(int state, PrinterDeviceBean printerDeviceBean) {

    }


    private String getLineBorder(String text, double fontSize) {
        if (fontSize == 0) {
            fontSize = 1;
        }
        //中文字符個數，Epson打印機每個中文字符佔1.5格
        double cnCount = getChineseValueLength(text);
        int count = (int) Math.floor(((lineLength / fontSize) - cnCount));
        if (count <= 0) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count / 2; i++) {
            builder.append("-");
        }
        builder.append(text);
        for (int i = 0; i < count / 2; i++) {
            builder.append("-");
        }
        return builder.toString();
    }

    public static double getChineseValueLength(String value) {
        double valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); i++) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 1.5;
            } else {
                valueLength += 1;
            }
        }
        return valueLength;
    }
}
