package com.joe.print.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.bean.PublicBean;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.utils.RxLifecycleUtils;
import com.joe.print.mvp.contract.LocalPrintContract;

import java.util.List;

import javax.inject.Inject;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;


@FragmentScope
public class LocalPrintPresenter extends BasePresenter<LocalPrintContract.Model, LocalPrintContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public LocalPrintPresenter(LocalPrintContract.Model model, LocalPrintContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getPrinterCurrencyList(int restaurant) {
        mModel.getPrinterCurrencyList(restaurant + "")
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<PublicBean>(mErrorHandler) {
                    @Override
                    public void onNext(PublicBean baseResult) {
                        if (baseResult != null) {

                            List<PrintCurrencyBean> printCurrencyBeans = JsonUtils.parseArray(baseResult.getData(), PrintCurrencyBean.class);
                            mRootView.loadView(printCurrencyBeans);
                        } else {
                            mRootView.loadView(null);
                        }
                    }
                });

    }
}
