package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;
import com.gingersoft.gsa.cloud.database.utils.ExpandInfoDaoUtils;
import com.gingersoft.gsa.cloud.print.bean.OrderDetails;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.PrintBillBean;
import com.joe.print.mvp.ui.adapter.BillItemAdapter;
import com.joe.print.mvp.ui.adapter.OtherOrderAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 打印外賣接單結賬單
 */
public class PrintOtherOrderClosing extends PrinterRoot {

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext) {
        OrderDetails.DataBean dataBean = MyOrderManage.getDataBean();
        if (dataBean != null) {
            Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
            List<Bitmap> bitmaps = new ArrayList<>();
            bitmaps.add(initPrintView(mContext, dataBean));
            bitmapMaps.put("", bitmaps);
            return bitmapMaps;
        }
        return null;
    }

    @Override
    public int getPrintCount(Context context) {
        ExpandInfoDaoUtils expandInfoDaoUtils = new ExpandInfoDaoUtils(context);
        List<ExpandInfo> expandInfos = expandInfoDaoUtils.queryAllExpandInfo();
        int printCount = 1;
        if (expandInfos != null) {
            for (ExpandInfo expandInfo : expandInfos) {
                if (expandInfo.getSettingName().equals(ExpandConstant.DeliveryPrintCount)) {
                    printCount = expandInfo.getValueInt();
                }
            }
        }
        return printCount;
    }

    private Bitmap initPrintView(Context context, OrderDetails.DataBean data) {
        View view = LayoutInflater.from(context).inflate(R.layout.print_confirm_order_view, null, false);
        TextView tvMemberNum = view.findViewById(R.id.tv_member_number);//會員號碼
        TextView tvMemberName = view.findViewById(R.id.tv_member_name);//會員名稱
        TextView tvMemberPhone = view.findViewById(R.id.tv_member_phone);//會員電話
        TextView tvNowPoint = view.findViewById(R.id.tv_nowPoints);//現在的積分
        TextView tvAddPoints = view.findViewById(R.id.tv_addPoints);//本次添加積分
        TextView tvOldPoints = view.findViewById(R.id.tv_oldPoints);//之前的積分
        TextView lineMember = view.findViewById(R.id.line_member_info);
        TextView tvOrderClosing = view.findViewById(R.id.tv_order_closing);
        TextView tvBillNumber = view.findViewById(R.id.tv_bill_number);
        //品牌名
        setText(view, R.id.tv_brand_name, GsaCloudApplication.getBrandName(context));
        //餐廳名
        setText(view, R.id.tv_restaurant_name, GsaCloudApplication.getRestaurantName(context));

        // 訂單號
        setText(view, R.id.tv_order_number, "單號：" + data.getORDER_NO());
        tvBillNumber.setVisibility(View.GONE);
        if (data.getOrder_type() == 2) {
            //外送
            // 訂單類型
            setText(view, R.id.tv_order_type, "外送");
            if (data.getTakeFoodCode() != null && !data.getTakeFoodCode().equals("0")) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getTakeFoodCode());
            } else if (data.getBillNo() != null && data.getBillNo().length() > 0) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getTakeFoodCode());
            }
        } else {
            setText(view, R.id.tv_order_type, "自取");
            if (data.getBillNo() != null && data.getBillNo().length() > 0) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getBillNo());
            } else if (data.getTakeFoodCode() != null && !data.getTakeFoodCode().equals("0")) {
                setText(view, R.id.tv_order_take_food_code, "訂單碼：" + data.getTakeFoodCode());
            }
        }
        //訂單創建時間
        setText(view, R.id.tv_order_create, context.getString(R.string.create_order_time) + TimeUtils.parseTimeRepeat(data.getCREATE_TIME(), TimeUtils.DEFAULT_DATE_FORMAT));
        String amountUnit = context.getString(R.string.amount_unit);

        RecyclerView rvBill = view.findViewById(R.id.rv_bill);
        List<PrintBillBean> billData = new ArrayList<>();
        billData.add(getBillBean("合計：", amountUnit + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE())));
        if (data.getLunchbox() != 0) {
            billData.add(getBillBean("餐盒費：", amountUnit + data.getLunchbox()));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            billData.add(getBillBean("送貨費：", amountUnit + data.getDELIVERY_CHARGE()));
        }
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                billData.add(getBillBean(coupon.getCouponName() + "：", "-$" + coupon.getDiscount_amount()));
            }
        }
        BillItemAdapter adapter = new BillItemAdapter(billData);
        rvBill.setLayoutManager(new LinearLayoutManager(context));
        rvBill.setAdapter(adapter);
        //總金額
        setText(view, R.id.tv_total, amountUnit + data.getTOTAL_AMOUNT());
        if (data.getOrderPayType() == 1) {
            //貨到付款
            setText(view, R.id.tv_pay_type, "貨到付款");
            if (data.getPayName() != null) {
                //支付金額
                setText(view, R.id.tv_pay_amount_text, data.getPayName() + "：" + amountUnit + MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()));
            } else {
                setIsShow(view, R.id.tv_pay_amount_text, false);
                setIsShow(view, R.id.tv_pay_amount_line, false);
            }
        } else if (data.getOrderPayType() == 0) {
            setText(view, R.id.tv_pay_type, "店內支付");
        } else if (data.getOrderPayType() == 2) {
            setText(view, R.id.tv_pay_type, "在線支付");
            setText(view, R.id.tv_pay_amount_text, data.getPayName() + "：" + amountUnit + MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getDiscount_amount()));
        }
        if (data.getPayTime() != null) {
            tvOrderClosing.setText("結賬時間：" + data.getPayTime());
            tvOrderClosing.setVisibility(View.VISIBLE);
        }
        //收貨時間
        setText(view, R.id.tv_delivery_time, data.getOrder_type() == 2 ? data.getSEND_TIME() : data.getTakeTime());
        if (data.getOrder_type() != 2) {
            //自取，隱藏地址和收貨人
            view.findViewById(R.id.tv_address).setVisibility(View.GONE);
            view.findViewById(R.id.tv_receiver).setVisibility(View.GONE);
        } else {
            //收貨地址
            setText(view, R.id.tv_address, context.getString(R.string.address) + data.getAddressDetail());
            //收貨人
            setText(view, R.id.tv_receiver, "收貨人：" + data.getRECEIVER());
        }
        //手機號
        setText(view, R.id.tv_phone, "手機號：" + data.getPHONE());
        //備註
        if (data.getRemark() != null && !data.getRemark().isEmpty()) {
            setText(view, R.id.tv_remark, "備註：" + data.getRemark());
            view.findViewById(R.id.tv_remark).setVisibility(View.VISIBLE);
        } else {
            view.findViewById(R.id.tv_remark).setVisibility(View.GONE);
        }
        if (data.getPRODUCT_NAME() != null) {
            RecyclerView rvFoodList = view.findViewById(R.id.rv_order_print_food);
            rvFoodList.setLayoutManager(new LinearLayoutManager(context));
            rvFoodList.setAdapter(new OtherOrderAdapter(context, data.getPRODUCT_NAME(), true));
        }
        if (data.getAddPoints() != 0 || data.getOldPoints() != 0 || data.getAddPoints() != 0) {
            tvAddPoints.setText("本次積分：" + data.getAddPoints());
            tvNowPoint.setText("結餘積分：" + data.getNowPoints());
            tvOldPoints.setText("上次積分：" + data.getOldPoints());
            //名稱中間替換為*號
            if (data.getMEMBER_NAME() != null && data.getMEMBER_NAME().length() > 0) {
                tvMemberName.setText("會員名稱：" + getReplaceAfter(data.getMEMBER_NAME()));
                tvMemberName.setVisibility(View.VISIBLE);
            }
            if (data.getPHONE() != null && data.getPHONE().length() > 0) {
                tvMemberPhone.setText("會員電話：" + getReplaceAfter(data.getPHONE()));
                tvMemberPhone.setVisibility(View.VISIBLE);
            }
            tvMemberName.setVisibility(View.VISIBLE);
            tvAddPoints.setVisibility(View.VISIBLE);
            tvNowPoint.setVisibility(View.VISIBLE);
            tvOldPoints.setVisibility(View.VISIBLE);
            lineMember.setVisibility(View.VISIBLE);
        }
        return viewToBitmap(context, view);
    }

    private PrintBillBean getBillBean(String title, String value) {
        return new PrintBillBean(title, value);
    }


    private String getReplaceAfter(String str) {
        if (str != null && str.length() > 0) {
            int replaceStrCount = str.length() / 2;
            StringBuilder buffer = new StringBuilder();
            if (replaceStrCount >= 5) {
                replaceStrCount = str.length() - 5;
            }
            for (int i = 0; i < replaceStrCount; i++) {
                buffer.append("*");
            }
            String header = str.substring(0, 1);
            String tail = str.substring(replaceStrCount + 1);
            return header + buffer.toString() + tail;
        }
        return "";
    }

}