package com.gingersoft.gsa.cloud.table.mvp.ui.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.MessageQueue;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.constraintlayout.widget.ConstraintLayout;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.table.R;
import com.jess.arms.utils.ArmsUtils;
import com.lxj.xpopup.util.KeyboardUtils;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButton;

/**
 * @作者: bin
 * @創建時間: 2021-03-11 17:38
 * @更新時間: 2021-03-11 17:38
 * @描述:
 */
public class CustomFoodDialog {

    private Context mContext;
    private QMUIDialog customDialog;
    private EditText ed_name, ed_money;

    private int mRadius;

    //0：value焦点、1：money焦点
    private int currFocus = 0;
    //0：清除、1：返回
    private int clearOrReturn = 1;

    private int mCustomType;

    public CustomFoodDialog(Context context, int customType) {
        this.mContext = context;
        this.mCustomType = customType;
        mRadius = QMUIDisplayHelper.dp2px(mContext, 8);
    }

    public CustomFoodDialog create(int style) {
        customDialog = new QMUIDialog.CustomDialogBuilder(mContext)
                .setLayout(R.layout.meal_dialog_custom_food)
                .create(style);
        buildViews();
        return this;
    }

    public void show() {
        if (customDialog != null) {
            customDialog.show();
        }
    }

    private void buildViews() {
        QMUILinearLayout llContainer = customDialog.findViewById(R.id.lLayout_bg);
        ViewStub vs_name = customDialog.findViewById(R.id.vs_name);
        ViewStub vs_money = customDialog.findViewById(R.id.vs_money);
        QMUIRoundButton btn_ok = customDialog.findViewById(R.id.btn_ok);
        QMUIRoundButton btn_clear_or_return = customDialog.findViewById(R.id.btn_clear_or_return);

        float mShadowAlpha = 0.25f;
        int mShadowElevationDp = 14;

        llContainer.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);
        llContainer.setLayoutParams(new ConstraintLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));


        if (mCustomType == Food.CUSTOM_TYPE_101) {
            vs_name.inflate();
            TextView tv_name = customDialog.findViewById(R.id.tv_name);
            ed_name = customDialog.findViewById(R.id.ed_name);
            tv_name.setText("名稱");
            setOnFocusChangeListener(ed_name);
            addTextChangedListener(ed_name, btn_clear_or_return);
        } else if (mCustomType == Food.CUSTOM_TYPE_102) {
            vs_money.inflate();
            TextView tv_money = customDialog.findViewById(R.id.tv_money);
            ed_money = customDialog.findViewById(R.id.et_money);
            tv_money.setText("金額");
            setOnFocusChangeListener(ed_money);
            addTextChangedListener(ed_money, btn_clear_or_return);
        } else {
            vs_name.inflate();
            vs_money.inflate();
            TextView tv_name = customDialog.findViewById(R.id.tv_name);
            TextView tv_money = customDialog.findViewById(R.id.tv_money);
            ed_name = customDialog.findViewById(R.id.ed_name);
            ed_money = customDialog.findViewById(R.id.et_money);
            tv_name.setText("名稱");
            tv_money.setText("金額");
            setOnFocusChangeListener(ed_name);
            setOnFocusChangeListener(ed_money);
            addTextChangedListener(ed_name, btn_clear_or_return);
            addTextChangedListener(ed_money, btn_clear_or_return);
        }

        btn_ok.setOnClickListener((view) -> {
            if (ed_name != null) {
                KeyboardUtils.hideSoftInput(ed_name);
            }
            if (ed_money != null) {
                KeyboardUtils.hideSoftInput(ed_money);
            }

            String name = getTvNameText();
            String money = getTvMoneyText();

            if (onEditListener != null) {
                onEditListener.onInput(customDialog,name, money);
            }
        });
        btn_clear_or_return.setOnClickListener((view) -> {
            if (clearOrReturn == 1) {
                customDialog.cancel();
            } else {
                //检查焦点
                String s;
                switch (currFocus) {
                    case 0:
                        s = ed_name.getText().toString();
                        if (s.length() > 0) {
                            s = s.substring(0, s.length() - 1);
                            ed_name.setText(s);
                            ed_name.setSelection(s.length());
                        }
                        break;
                    case 1:
                        s = ed_money.getText().toString();
                        if (s.length() > 0) {
                            s = s.substring(0, s.length() - 1);
                            ed_money.setText(s);
                            ed_money.setSelection(s.length());
                        }
                        break;
                }
            }
        });
    }

    private void setOnFocusChangeListener(EditText editText) {
        editText.setOnFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                if (editText.getId() == R.id.ed_name) {
                    currFocus = 0;
                } else {
                    currFocus = 1;
                }
            }
        });
    }

    private void addTextChangedListener(EditText editText, Button btn_clear_or_return) {
        editText.addTextChangedListener(new TextWatcher() {

            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s.length() > 0) {
                    clearOrReturn = 0;
                } else {
                    clearOrReturn = 1;
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (clearOrReturn == 0) {
                    btn_clear_or_return.setText(LanguageUtils.get_language_system(GsaCloudApplication.getAppContext(), "Meal.funcMoney.clear", "clear"));
                } else {
                    btn_clear_or_return.setText(LanguageUtils.get_language_system(GsaCloudApplication.getAppContext(), "Return", "return"));
                }
            }
        });
    }


    private String getTvNameText() {
        return ed_name != null ? ed_name.getText().toString() : null;
    }

    private String getTvMoneyText() {
        return ed_money != null ? ed_money.getText().toString() : null;
    }

    private OnEditListener onEditListener;

    public CustomFoodDialog setOnEditListener(OnEditListener onEditListener) {
        this.onEditListener = onEditListener;
        return this;
    }

    public interface OnEditListener {
        void onInput(Dialog dialog,String name, String money);
    }
}
