package com.gingersoft.gsa.cloud.print.bean;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/28
 * Time: 18:18
 * Use:
 */
@Data
public class UpdateBean {
    //    1未打印 2打印中 3已打印 4 打印失敗，5 未查詢到打印機請查詢打印管理配置是否正確，6 未生成打印數據請嘗試重印，7 未連接打印機請重啟打印機，8 打印機連接超時請重啟打印機，9 用戶沒有配置IP請查詢打印管理配置是否正確，10 打印機連接成功數據未發送請嘗試重印
    /**
     * 1未打印
     */
    public static final int NO_PRINT = 1;
    /**
     * 2打印中
     */
    public static final int PRINTING = 2;
    /**
     * 3已打印
     */
    public static final int ALREADY_PRINT = 3;
    /**
     * 4 打印失敗
     */
    public static final int FAILED_PRINT = 4;
    /**
     * 5 未查詢到打印機請查詢打印管理配置是否正確
     * 通過打印位置沒有找到對應的打印機
     */
    public static final int FAIL_PRINT_BY_NOT_FIND_DEVICE = 5;
    /**
     * 6 未生成打印數據請嘗試重印
     * 沒有生成打印數據
     */
    public static final int FAIL_PRINT_BY_NOT_PRINT_INFO = 6;
    /**
     * 7 未連接打印機請重啟打印機
     */
    public static final int FAIL_PRINT_BY_NOT_CONNECT = 7;
    /**
     * 8 打印機連接超時請重啟打印機
     */
    public static final int FAIL_PRINT_BY_CONNECT_TIMEOUT = 8;
    /**
     * 9 用戶沒有配置IP請查詢打印管理配置是否正確
     * 沒有配置ip
     */
    public static final int FAIL_PRINT_IS_NOT_IP = 9;

    /**
     * 10 打印機連接成功數據未發送請嘗試重印
     * 1、寫入數據時出現異常
     * 2、獲取socket輸出流失敗
     */
    public static final int FAIL_PRINT_IS_NOT_SEND = 10;
    /**
     * 11 打印機沒紙
     */
    public static final int FAIL_NOT_PAPER = 11;
    /**
     * 12 針式打印機初始化失敗
     */
    public static final int FAIL_EPSON_INIT = 12;
    /**
     * 13 sunmi打印機過熱
     */
    public static final int FAIL_SUNMI_PRINT_HOT = 13;
    /**
     * 14 SUNMI打印機蓋子未合上
     */
    public static final int FAIL_LID_NOT_CLOSED_SUNMI = 14;
    /**
     * 15 SUNMI打印機切刀異常
     */
    public static final int FAIL_CUT_ABNORMAL_SUNMI = 15;
    /**
     * 16 SUNMI打印機未檢測到黑標
     */
    public static final int FAIL_SUNMI_NO_BLACK_MARK_DETECTED = 16;
    /**
     * 17 本地打印但是沒有找到這個型號的打印機
     */
    public static final int FAIL_LOCAL_PRINT_NOT_DEVICE = 17;
    /**
     * 18 USB打印失敗，未添加到後台
     */
    public static final int FAIL_USB_PRINT = 18;
    /**
     * 19 未找到USB打印機，未添加到後台
     */
    public static final int FAIL_USB_PRINT_NOT_FIND = 19;
    /**
     * 20 生成打印數據失敗
     */
    public static final int FAIL_GENERATE_PRINT_INFO = 20;











    /**
     * 505 SUNMI未查詢到打印機請查詢打印管理配置是否正確
     * 通過打印位置沒有找到對應的打印機
     */
    public static final int FAIL_PRINT_BY_NOT_FIND_DEVICE_SUNMI = 505;
    /**
     * 507 SUNMI打印機固件升級失敗
     */
    public static final int FAIL_SUNMI_FIRMWARE_UPGRADE_FAILED = 507;
    /**
     * -1 N5未知錯誤
     */
    public static final int FAIL_N5_PRINT_UNKNOWN = -1;
    /**
     * -1001 N5打印失败
     */
    public static final int FAILED_PRINT_N5 = -1001;
    /**
     * -1005 N5打印缺紙
     */
    public static final int FAILED_PRINT_NOT_PAPER_N5 = -1005;
    /**
     * -1008 N5打印過熱
     */
    public static final int FAIL_N5_PRINT_HOT = -1008;
    /**
     * -1009 N5打印了但是沒有完全打印完
     */
    public static final int FAIL_PRINT_N5_INCOMPLETE = -1009;

    public static String getStateByCode(int code) {
        switch (code) {
            case NO_PRINT:
                return "未打印";
            case PRINTING:
                return "打印中";
            case FAIL_PRINT_BY_NOT_FIND_DEVICE:
                return "未查詢到打印機，請檢查打印配置是否正確";
            case FAIL_PRINT_BY_NOT_PRINT_INFO:
                return "生成打印數據失敗，請嘗試重印";
            case FAIL_PRINT_BY_NOT_CONNECT:
                return "連接打印機失敗，請檢查打印機網絡";
            case FAIL_PRINT_BY_CONNECT_TIMEOUT:
                return "打印機連接超時，請檢查打印機網絡";
            case FAIL_PRINT_IS_NOT_IP:
                return "沒有配置IP,請檢查打印配置是否正確";
            case FAIL_PRINT_IS_NOT_SEND:
                return "打印機連接成功,數據未發送，請嘗試重印";
            case FAIL_NOT_PAPER:
                return "打印機缺紙，請檢查打印紙";
            case FAIL_EPSON_INIT:
                return "針式打印機初始化失敗，請檢查設備";
            case FAIL_SUNMI_PRINT_HOT:
                return "sunmi打印機過熱，導致無法打印，請檢查設備";
            case FAIL_LID_NOT_CLOSED_SUNMI:
                return "sunmi打印機未關閉紙蓋，請檢查設備";
            case FAIL_CUT_ABNORMAL_SUNMI:
                return "sunmi打印機切刀異常，請檢查設備";
            case FAIL_SUNMI_NO_BLACK_MARK_DETECTED:
                return "sunmi打印機未檢測到黑標，請檢查設備";
            case FAIL_LOCAL_PRINT_NOT_DEVICE:
                return "未找到對應型號的本地打印機，請檢查設備型號";
            case FAIL_PRINT_BY_NOT_FIND_DEVICE_SUNMI:
                return "sunmi連接失敗，請檢查設備";
            case FAIL_SUNMI_FIRMWARE_UPGRADE_FAILED:
                return "sunmi固件升級失敗，請檢查設備";
            case FAIL_N5_PRINT_UNKNOWN:
            case FAILED_PRINT_N5:
                return "NEXGO打印失敗，請重試";
            case FAILED_PRINT_NOT_PAPER_N5:
                return "NEXGO缺紙，請檢查打印紙";
            case FAIL_N5_PRINT_HOT:
                return "NEXGO打印過熱終止，請檢查設備";
            case FAIL_PRINT_N5_INCOMPLETE:
                return "NEXGO打印異常終止，請檢查設備";
            default:
                return "" + code;
        }
    }

    public UpdateBean(String id, int printerType, Long printerTime) {
        this.id = id;
        this.printerType = printerType;
        this.printerTime = printerTime;
    }

    private String id;
    private int printerType;
    private Long printerTime;
}
