package com.gingersoft.gsa.cloud.common.function.click;

import android.util.Log;

import com.gingersoft.gsa.cloud.common.core.user.UserContext;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

/**
 *
 * @author Wyh
 * @date 2018/6/13
 */
@Aspect
public class CheckLoginAspect {

    @Pointcut("execution(@com.gingersoft.gsa.cloud.common.function.click.CheckLoginState * *(..))")
    public void onCheckMethod() {
    }

    @Around("onCheckMethod()")//在连接点进行方法替换
    public void doCheckMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        if (UserContext.newInstance().isLogin()) {
            //登錄了，执行原方法
            joinPoint.proceed();
        } else {
            //沒登錄，攔截
        }
    }
}
