package com.gingersoft.gsa.cloud.order.bean.response;


import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.order.bean.discount.CouponDiscountBean;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-12
 * 修订历史：2020-09-12
 * 描述：扫码查询优惠券折扣返回实体
 */
@Data
public class CouponDiscountResponse {

    /**
     * 會員優惠券信息
     */
    private CouponDiscountBean couponBean;
    /**
     * 會員信息
     */
    private MemberInfo memberInfo;

    /**會已在其他餐廳使用*/
    public static final String ERROR_CODE_0001 = "MEMBER.0001";
    /**掃描的會員優惠券與當前品牌不一致*/
    public static final String ERROR_CODE_0002 = "MEMBER.0002";
    /**掃了其他會員的優惠券碼*/
    public static final String ERROR_CODE_0003 = "MEMBER.0003";

}
