package com.gingersoft.coldchain_module.mvp.model;

import android.app.Application;

import com.gingersoft.coldchain_module.mvp.contract.ColdChainMainContract;
import com.gingersoft.coldchain_module.mvp.model.bean.BalanceBean;
import com.gingersoft.coldchain_module.mvp.model.bean.OrderList;
import com.gingersoft.coldchain_module.mvp.model.bean.PickUpBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ShipAnyOrdersNewBean;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementInfoBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateOrderStatusBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateRestaurantStateBean;
import com.gingersoft.coldchain_module.mvp.model.service.ColdChainService;
import com.gingersoft.coldchain_module.mvp.model.service.OrderDetailService;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;
import okhttp3.RequestBody;


@ActivityScope
public class ColdChainMainModel extends BaseModel implements ColdChainMainContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public ColdChainMainModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<OrderList> getOrderList(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).getOrderList(requestBody);
    }

    @Override
    public Observable<SupplementInfoBean> getNumByOrderType(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).getNumByOrderType(requestBody);
    }

    @Override
    public Observable<PickUpBean> pickUp(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).pickUp(requestBody);
    }

    @Override
    public Observable<BalanceBean> getBalance(String brandId) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).getBalance(brandId);
    }

    @Override
    public Observable<UpdateRestaurantStateBean> updateRestOpenStatus(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).updateRestOpenStatus(requestBody);
    }

    @Override
    public Observable<Object> updateExpandInfo(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(ColdChainService.class).updateExpandInfo(requestBody);
    }

    @Override
    public Observable<OrderDetails> findOrderDetails(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).findOrderDetails(requestBody);
    }

    @Override
    public Observable<ShipAnyOrdersNewBean> thirdDelivery(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).thirdDelivery(requestBody);
    }

    @Override
    public Observable<UpdateOrderStatusBean> updateOrderStatus(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).gsUpdateOrderStatus(requestBody);
    }

    @Override
    public Observable<String> addPrj(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(OrderDetailService.class).addPrj(requestBody);
    }

}