package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;
import com.gingersoft.supply_chain.mvp.bean.FoodByCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodListInfoBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodListVosBean;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/24/2020 15:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface FoodIngredientsContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadLeftSupplierInfo(List<CategoryBean> categoryBeans);

        void loadRightFoodIngredients(List<PurchaseFoodListVosBean> purchaseFoodListVOS);

        /**
         * 刪除食品成功回調
         *
         * @param position
         */
        void onDeleteFoodSuccess(int position);

        /**
         * 加載左側分類
         *
         * @param foodCategoryTrees 所有分類層級信息
         */
        void loadCategory(List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTrees);

        void loadFail();

        void setCurrentSupplierName(String name);

        void setCurrentCategoryName(String name);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<FoodListInfoBean> getFoodIngredientsData(Map<String, Object> map);

        Observable<BaseResult> getFoodBySupplierId(Map<String, Object> map);

        Observable<BaseResult> updateFood(RequestBody requestBody);

        Observable<OrderCategoryBean> getCategoryTrees(Map<String, Object> map);

        Observable<FoodByCategoryResultBean> getFoodByCategory(Map<String, Object> map);
    }
}
