package com.gingersoft.gsa.cloud.ui.widget.dialog;

import android.app.Activity;
import android.text.TextUtils;
import android.widget.EditText;

import com.gingersoft.gsa.cloud.common.R;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-04-03
 * 修订历史：2020-04-03
 * 描述：常用提示Dialog
 */
public class CommonTipDialog {


    /**
     * 提示dialog 確認后執行對應方法
     *
     * @param context
     * @param msg
     * @param c
     * @param object
     * @param methodName
     * @param parameterTypes
     * @param parameters
     */
    public static void showDoubtDialog(Activity context, String msg, Class c, Object object, String methodName, Class[] parameterTypes, Object[] parameters) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage(msg);
        dialogBuilder.addAction(R.drawable.shape_red_five_radius_bg, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (TextUtils.isEmpty(methodName)) {
                return;
            }
            try {
                Method method = c.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                method.invoke(object, parameters);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
        if (!TextUtils.isEmpty(methodName)) {
            dialogBuilder.addAction(R.drawable.shape_3c_cancel_btn_bg, "取消", (dialog, index) -> dialog.dismiss());
        }
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    public static void showDoubtDialog2(Activity context, String msg, OnCallbackListener listener) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage(msg);
        dialogBuilder.addAction(R.drawable.shape_red_five_radius_bg, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (listener != null) {
                listener.onSure();
            }
        });
        dialogBuilder.addAction(R.drawable.shape_3c_cancel_btn_bg, "取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    /**
     * 危險警示dialog 確認后執行對應方法
     *
     * @param context
     * @param msg
     * @param c
     * @param object
     * @param methodName
     * @param parameterTypes
     * @param parameters
     */
    public static void showSurpisedDialog(Activity context, String msg, Class c, Object object, String methodName, Class[] parameterTypes, Object[] parameters) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setMessage(msg);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_surprised);
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (TextUtils.isEmpty(methodName)) {
                return;
            }
            try {
                Method method = c.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                method.invoke(object, parameters);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
        if (!TextUtils.isEmpty(methodName)) {
            dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        }
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    /**
     * 警示dialog 確認后執行對應方法
     *
     * @param context
     * @param msg
     * @param c
     * @param object
     * @param methodName
     * @param parameterTypes
     * @param parameters
     */
    public static void showWarnDialog(Activity context, String msg, Class c, Object object, String methodName, Class[] parameterTypes, Object[] parameters) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setMessage(msg);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_warn);
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (TextUtils.isEmpty(methodName)) {
                return;
            }
            try {
                Method method = c.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                method.invoke(object, parameters);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
        if (!TextUtils.isEmpty(methodName)) {
            dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        }
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    /**
     * 取消 dialog 確認后執行對應方法
     *
     * @param context
     * @param msg
     * @param c
     * @param object
     * @param methodName
     * @param parameterTypes
     * @param parameters
     */
    public static void showCancelDialog(Activity context, String msg, Class c, Object object, String methodName, Class[] parameterTypes, Object[] parameters) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setMessage(msg);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_cancel);
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (TextUtils.isEmpty(methodName)) {
                return;
            }
            try {
                Method method = c.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                method.invoke(object, parameters);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
        if (!TextUtils.isEmpty(methodName)) {
            dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        }
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    public static void showTipDialog(Activity context, String msg) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage(msg);
        dialogBuilder.addAction("確定", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }


    /**
     * 輸入型 dialog 確認后執行對應方法
     *
     * @param context
     * @param title
     * @param placeholder
     */
    public static EditText showEditDialog(Activity context, String title, String placeholder, int inputType, OnEditTextListener onEditTextListener) {
        final QMUIDialog.EditTextDialogBuilder dialogBuilder = new QMUIDialog.EditTextDialogBuilder(context);
        dialogBuilder.setTitle(title);
        dialogBuilder.setPlaceholder(placeholder);
        dialogBuilder.setInputType(inputType);
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (onEditTextListener != null) {
                CharSequence text = dialogBuilder.getEditText().getText();
                if (!TextUtils.isEmpty(text)) {
                    onEditTextListener.inputText(text.toString());
                }
            }
        });
        dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyEditDialogTheme).show();
        return dialogBuilder.getEditText();
    }

    private OnEditTextListener onEditTextListener;
    private OnCallbackListener onCallbackListener;

    public void setOnEditTextListener(OnEditTextListener onEditTextListener) {
        this.onEditTextListener = onEditTextListener;
    }

    public void setOnCallbackListener(OnCallbackListener onCallbackListener) {
        this.onCallbackListener = onCallbackListener;
    }

    public interface OnEditTextListener {
        void inputText(String text);
    }

    public interface OnCallbackListener {
        void onSure();
    }
}
