package com.gingersoft.gsa.delivery_pick_mode.ui.adapter

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.databinding.DataBindingUtil
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.gingersoft.gsa.delivery_pick_mode.R
import com.gingersoft.gsa.delivery_pick_mode.data.model.bean.DeliveryConfig
import com.gingersoft.gsa.delivery_pick_mode.databinding.ItemDeliveryLayoutBinding
import com.gingersoft.gsa.delivery_pick_mode.ui.fragment.UpdateDeliveryFragment

class DeliveryListAdapter(data: MutableList<DeliveryConfig.Data.DeliveryInfo>) : BaseQuickAdapter<DeliveryConfig.Data.DeliveryInfo, DeliveryListAdapter.ViewHolder>(R.layout.item_delivery_layout, data) {

    override fun convert(holder: ViewHolder, item: DeliveryConfig.Data.DeliveryInfo) {
        holder.let { helper ->
            helper.binding.apply {
                deliveryType = when (item.distributionType) {
                    "SHORT_RANGE" -> "短途送"
                    "STANDARD" -> "中途送"
                    "LONG_DISTANCE" -> "長途送"
                    else -> ""
                }
                item.let {
                    //                    deliveryType = it.distributionType
                    deliveryExpenses = "${it.distributionFeeMin}-${it.distributionFeeMax}"
                    deliveryFee = it.deliveryCost.toString()
                    deliveryMethod = UpdateDeliveryFragment.deliveryMethod[it.type]
                    deliveryDifference = it.lackPrice.toString()
                }
            }
            helper.getView<ImageView>(R.id.iv_delete).setOnClickListener {
                getOnItemChildClickListener()?.onItemChildClick(this, it, helper.adapterPosition)
            }
            helper.itemView.setOnClickListener {
                getOnItemChildClickListener()?.onItemChildClick(this, it, helper.adapterPosition)
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(parent.context).inflate(R.layout.item_delivery_layout, null)
        return ViewHolder(view)
    }

    class ViewHolder(itemView: View) : BaseViewHolder(itemView) {
        var binding: ItemDeliveryLayoutBinding = DataBindingUtil.bind(itemView)!!
    }

}