package com.gingersoft.gsa.cloud.table.mvp.contract;

import android.app.Activity;
import android.widget.BaseAdapter;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Discount;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseOrderRespose;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.FoodReason;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import androidx.recyclerview.widget.RecyclerView;
import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:17
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface MealStandContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends BaseOrderContract.View {

        boolean isInitFineItemLayout();

        int getRestaurantId();

        void initFineItemTabBarViewPage();

        void updateMemberInfo(MemberInfo memberInfo);

        void setCurrentFinePage();

        void setPluMode();

        void resetPluMode();

        void recordOperat(boolean isPressButtonSound);

        void showChoosePeopleNumDialog(boolean isNeedCancel);

        void setPrinterLocalmachine(boolean isPrint);

        void setTableInfoDialogAdapter(BaseAdapter adapter);

        void setSelectFoodAdapter(RecyclerView.Adapter adapter);

        void setFoodGroupAdapter(DefaultAdapter adapter);

        void setFoodAdapter(DefaultAdapter adapter);

        void setComboAdapter(DefaultAdapter adapter);

        void setModifierAdapter(DefaultAdapter adapter);

        void setDiscountAdapter(DefaultAdapter adapter);

        void setSelectFoodRecycleLayoutManager();

        void setFoodGroupRecycleLayoutManager(int orientation);

        void setFoodRecycleLayoutManager(int orientation);

        void setComboRecycleLayoutManager(int orientation);

        void setModifierRecycleLayoutManager(int orientation);

        void setDiscountRecycleLayoutManager(int orientation);

        void setFoodGroupRecycleSpanCount(int size);

        void setFoodRecycleSpanCount(int size);

        void setComboRecycleSpanCount(int size);

        void setModifierRecycleSpanCount(int size);

        void setDiscountRecycleSpanCount(int size);

        void showViewModeVisibility(int... viewMode);

        void showModifyLayoutVisibility(boolean show);

        void showBtnMealModifyRestoreVisibility(boolean show);

        void setOrderFoodCount(String number);

        void setMealRvScrollToPosition(int position);

        Activity getActivity();

        void setModifierTop(int Margins);


    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends BaseOrderContract.Model {

        Observable<BaseResult> getCurrentSoldoutFood(RequestBody requestBody);

        Observable<BaseResult> createOrder(RequestBody requestBody);

        Observable<BaseResult> addFood(RequestBody requestBody);

        Observable<BaseOrderRespose> loadOrder(long orderId);

        //        Observable<BaseOrderRespose> deleteFood(List<Map<Byte, DeleteOrderRequest>> mapsDelete, long orderId, byte type, int reasonId);
        Observable<BaseOrderRespose> deleteFood(RequestBody requestBody);

        Observable<BaseOrderRespose> printOrder(RequestBody requestBody);

        Observable<FoodReason> getRestaurantFoodReason(int brandId, int restaurantId, int type);

        Observable<BaseResult> queryMember(int type, String  parm, String shopName,int tableId,String tableNumber);

        Observable<BaseResult> memberUse(int tableId, String  tableNumber, long memberId);

        Observable<BaseResult> memberUseCancel(int tableId, String  tableNumber, long memberId);

        List<Food> queryDB_AllFoodList();

        List<Food> queryDB_FoodGroupList(int foodSummary);

        List<Food> queryDB_FoodList(long parentId,int foodSummary);

        List<Modifier> queryDB_ModifierList(long fid, int mode);

        List<ComboItem> queryDB_ComboList(long fid);

        List<FoodCombo> isComboFood(long fid);

        List<FoodModifier> queryDB_FoodModifierList(long fid);

        List<Discount> queryDB_DiscountList(String discountType);
    }
}
