package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.aspectj.XClickUtil;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.ui.view.BeveLabelView;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;

import java.util.List;

import androidx.recyclerview.widget.GridLayoutManager;
import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class FoodAdapter extends DefaultAdapter<Food> {

    private Context mContext;

    private int mOrderNumberShowSize;
    private int mOrderNumberFontSize;
    private int mFoodFontSize;

    private int mColwidth;
    private int mColHeight;
    private int mLayoutQtyHeight;

    private int currentSelectPosition = 0;

    private int user_qty;//在进入的的数量
    public boolean check_qty = false;//是否检查数理

    /**
     * 作為那個頁面的適配器:1=餐牌頁;2=沽清頁
     */
    private int mFromType = 1;

    public FoodAdapter(Context context, List<Food> infos, int fromType) {
        super(infos);
        this.mContext = context;
        this.mFromType = fromType;
        this.mOrderNumberShowSize = GsaCloudApplication.uiStyleConfiguration.getOrderNumberChildShowSize();
        this.mOrderNumberFontSize = GsaCloudApplication.uiStyleConfiguration.getOrderNumberChildFontSize();
        this.mFoodFontSize = GsaCloudApplication.uiStyleConfiguration.getFoodFontSize();
        this.mColwidth = (int) ((DeviceUtils.getScreenWidth(context) / GsaCloudApplication.uiStyleConfiguration.getFoodColumn()));
        this.mColHeight = GsaCloudApplication.uiStyleConfiguration.getFoodBtnHeight();
        this.mLayoutQtyHeight = GsaCloudApplication.uiStyleConfiguration.getLayoutQtyHeight();
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Food> getHolder(View v, int viewType) {
        return new FoodItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_food;
    }

    class FoodItemHolder extends BaseHolder<Food> {

        @BindView(R2.id.rl_container)
        RelativeLayout rl_container;
        @BindView(R2.id.tv_food_name)
        TextView tv_food_name;
        @BindView(R2.id.tv_number)
        TextView tv_number;
        @BindView(R2.id.tv_soldout)
        TextView tv_soldout;
        @BindView(R2.id.iv_qtySold)
        ImageView iv_qtySold;
        @BindView(R2.id.blv_soldout)
        BeveLabelView blv_soldout;

        public FoodItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Food datasBean, int position) {

            setFood(datasBean);
            setNumber(datasBean);
            setColor(datasBean);
            setStatus(datasBean);

            setOnItemClickListener((view, position1) -> {
                if (XClickUtil.isFastDoubleClick(view, 200)) {
                    return;
                }
                resetSelect(position1, datasBean);
            });
        }

        public void setFood(Food datasBean) {
//            String desc = "";
//            switch (GsaCloudApplication.androidSetting.getDataLanguage()) {
//                case 1:
//                    desc = datasBean.getDesc1();
//                    break;
//                case 2:
//                    desc = datasBean.getDesc2();
//                    break;
//                case 3:
//                    desc = datasBean.getDesc3();
//                    break;
//            }
//            if (desc == null || desc.trim().length() == 0) {
//                desc = datasBean.getDesc1();
//            }

            tv_food_name.setMaxWidth(mColwidth);
            tv_food_name.setMinWidth(mColwidth);
            tv_food_name.setWidth(mColwidth);

            tv_food_name.setText(datasBean.getFoodName());
            tv_food_name.setTextSize(mFoodFontSize);
            tv_food_name.setHeight(mColHeight);
            tv_food_name.setGravity(Gravity.CENTER);
            tv_food_name.setSingleLine(false);

            GridLayoutManager.LayoutParams lp = (GridLayoutManager.LayoutParams) rl_container.getLayoutParams();
            lp.height = mColHeight;
            lp.width = mColwidth;
            rl_container.setLayoutParams(lp);
        }

        public void setNumber(Food datasBean) {

            ViewGroup.MarginLayoutParams mp = new ViewGroup.MarginLayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);  //item的宽高
            mp.setMargins(0, 0, 0, 0);//分别是margin_top那四个属性

            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(mp);
            lp.width = ArmsUtils.dip2px(mContext, 16);
            lp.height = ArmsUtils.dip2px(mContext, 16);
            lp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
            tv_number.setLayoutParams(lp);

            tv_number.setTextSize(10);
            tv_number.setHeight(mLayoutQtyHeight);

            if (datasBean.getNumber() == 0) {
                tv_number.setVisibility(View.INVISIBLE);
            } else {
                tv_number.setVisibility(View.VISIBLE);
                tv_number.setText(datasBean.getNumber() + "");
            }
        }

        private void setStatus(Food datasBean) {

//            tv_soldout.setMaxHeight(mOrderNumberShowSize);
//            tv_soldout.setMinHeight(mOrderNumberShowSize);
            tv_soldout.setTextSize(mOrderNumberFontSize);
//            tv_soldout.setTextColor(Color.parseColor("#000000"));
            tv_soldout.setBackgroundDrawable(mContext.getResources().getDrawable(R.drawable.meal_shape_remaining_number_bg));
//            tv_soldout.setMinWidth(20);
//            tv_soldout.setTextSize(10);
//            tv_soldout.setGravity(Gravity.CENTER);

//            RelativeLayout.LayoutParams lp2 = new RelativeLayout.LayoutParams(new ViewGroup.MarginLayoutParams(60, 40));
//            lp2.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
//            lp2.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
//            tv_soldout.setLayoutParams(lp2);

            tv_soldout.setVisibility(View.INVISIBLE);
            iv_qtySold.setVisibility(View.INVISIBLE);
            blv_soldout.setVisibility(View.INVISIBLE);

            String qty = datasBean.getCurrentMaxNumber();
            if (TextUtils.isEmpty(qty)) {
                tv_soldout.setVisibility(View.INVISIBLE);
            } else {
                if (qty.equalsIgnoreCase("售罄") || qty.equalsIgnoreCase("暫停") ) {
                    blv_soldout.setLableText(qty);
                    blv_soldout.setVisibility(View.VISIBLE);
                } else {
                    tv_soldout.setVisibility(View.VISIBLE);
                    tv_soldout.setText(qty);
                }
            }
        }

        private void setColor(Food datasBean) {
            if (datasBean.isSelected()) {
                tv_food_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.orange_500));
                tv_food_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
            } else {
                tv_food_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.light_blue_500));
                tv_food_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
            }
        }
    }

    public void resetSelect(int position, Food datasBean) {
        if (position < 0) {
            if (mInfos != null && mInfos.size() > currentSelectPosition) {
                //重置上次選中
                mInfos.get(currentSelectPosition).setSelected(false);
                notifyItemChanged(currentSelectPosition);
            }
            return;
        }
        for (int i = 0; i < mInfos.size(); i++) {
            mInfos.get(i).setSelected(false);
        }
        if (currentSelectPosition == 0 || currentSelectPosition != position) {

            if (currentSelectPosition < mInfos.size()) {
                //重置上次选中item的颜色
                mInfos.get(currentSelectPosition).setSelected(false);
                notifyItemChanged(currentSelectPosition);
            }

            //设置当前选中item颜色
            if (datasBean != null)
                datasBean.setSelected(true);
            notifyDataSetChanged();

            //保存上次操作的position
            currentSelectPosition = position;
        }

        if (mOnItemClickListener != null) {
            mOnItemClickListener.onItemClick(mInfos.get(position), position);
        }
    }

    public int getCurrentSelectPosition() {
        return currentSelectPosition;
    }

    public void setCurrentSelectPosition(int currentSelectPosition) {
        this.currentSelectPosition = currentSelectPosition;
    }

    public int getUser_qty() {
        return user_qty;
    }

    public void setUser_qty(int user_qty) {
        this.user_qty = user_qty;
    }

    public boolean isCheck_qty() {
        return check_qty;
    }

    public void setCheck_qty(boolean check_qty) {
        this.check_qty = check_qty;
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Food datasBean, int position);

    }
}
