package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.OtherFunctionModule;
import com.gingersoft.supply_chain.mvp.contract.OtherFunctionContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.OtherFunctionFragment;


/**
 * ================================================
 * Created by zjs on 07/07/2021 21:11
 * Description
 * ================================================
 */
@FragmentScope
@Component(modules = OtherFunctionModule.class, dependencies = AppComponent.class)
public interface OtherFunctionComponent {
    void inject(OtherFunctionFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        OtherFunctionComponent.Builder view(OtherFunctionContract.View view);

        OtherFunctionComponent.Builder appComponent(AppComponent appComponent);

        OtherFunctionComponent build();
    }

}