package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.PurchaseWarehousingOrderDetailsVO;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/6
 * Time: 16:36
 * Use:庫存查詢列表的首列
 */
public class WarehousingFirstColumnAdapter extends BaseQuickAdapter<PurchaseWarehousingOrderDetailsVO, BaseViewHolder> {

    private Context context;
    private int[] colors = new int[]{R.color.color_f9, R.color.white};

    public WarehousingFirstColumnAdapter(Context context, List<PurchaseWarehousingOrderDetailsVO> purchaseWarehousingOrderDetailsVosBeans) {
        super(R.layout.item_warehousing_head, purchaseWarehousingOrderDetailsVosBeans);
        this.context = context;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, PurchaseWarehousingOrderDetailsVO item) {
        viewHolder.setText(R.id.tv_warehouse_item_ingredients_name, item.getName());
        viewHolder.setGone(R.id.tv_warehouse_item_ingredients_name, false);
        viewHolder.setText(R.id.tv_warehouse_item_ingredients_species, item.getFoodCategoryName());
        viewHolder.setText(R.id.tv_warehouse_item_unit, item.getUnitName());
        viewHolder.setText(R.id.tv_warehouse_item_unit_price, item.getFoodPrice() + "");
        viewHolder.setText(R.id.tv_warehouse_item_inventory_quantity, item.getFoodNum() + "");
        viewHolder.setText(R.id.tv_warehouse_item_total_amount, item.getFoodAmount() + "");

        viewHolder.setGone(R.id.tv_warehouse_item_ingredients_species, true);
        viewHolder.setGone(R.id.tv_warehouse_item_unit, true);
        viewHolder.setGone(R.id.tv_warehouse_item_unit_price, true);
        viewHolder.setGone(R.id.tv_warehouse_item_inventory_quantity, true);
        viewHolder.setGone(R.id.tv_warehouse_item_total_amount, true);

        int textColorRes = getColor(R.color.color_3c);
        viewHolder.setTextColor(R.id.tv_warehouse_item_ingredients_name, textColorRes);

        int colorRes = getColor(colors[viewHolder.getAdapterPosition() % 2]);
        viewHolder.setBackgroundColor(R.id.tv_warehouse_item_ingredients_name, colorRes);

        viewHolder.setBackgroundColor(R.id.tv_head_layout_res_id, getColor(R.color.trans));
    }

    private int getColor(int colorRes) {
        return ContextCompat.getColor(context, colorRes);
    }
}
