package com.gingersoft.gsa.cloud.base.utils.other;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;

import com.gingersoft.gsa.cloud.base.utils.log.LogUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: AppUtil
 * @Description:TODO(App相关的辅助类)
 */
public class AppUtils {

    /**
     * 获取应用程序名称
     *
     * @param context
     * @return
     */
    public static String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(
                    context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        } catch (NameNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取版本号
     *
     * @param context
     * @return
     */
    public static int getVerCode(Context context) {
        int verCode = -1;
        try {
            verCode = context.getPackageManager().getPackageInfo(
                    context.getPackageName(), 0).versionCode;
        } catch (NameNotFoundException e) {
            e.printStackTrace();
            LogUtil.e(e.getMessage());
        }
        return verCode;
    }

    /**
     * 获取版本名称
     *
     * @param context
     * @return
     */
    public static String getVerName(Context context) {
        String verName = "";
        try {
            verName = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        } catch (NameNotFoundException e) {
            LogUtil.e(e.getMessage());
        }
        return verName;
    }

    /**
     * 获取手机mac地址
     *
     * @param context
     * @return
     */
    public static String getLocalMacAddress(Context context) {
        WifiManager wifi = (WifiManager) context
                .getSystemService(Context.WIFI_SERVICE);
        WifiInfo info = wifi.getConnectionInfo();
        return info.getMacAddress();
    }

    /**
     * 启动到应用商店app详情界面
     *
     * @param appPkg    目标App的包名
     * @param marketPkg 应用商店包名 ,如果为""则由系统弹出应用商店列表供用户选择,否则调转到目标市场的应用详情界面，某些应用商店可能会失败
     */
    public static void launchAppDetail(Context mContext, String appPkg, String marketPkg) throws Exception {
        if (TextUtils.isEmpty(appPkg)) return;
        Uri uri = Uri.parse("market://details?id=" + appPkg);
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        if (!TextUtils.isEmpty(marketPkg)) {
            intent.setPackage(marketPkg);
        }
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        mContext.startActivity(intent);
    }

    /**
     * 验证是否已安装应用并返回apk信息
     *
     * @param system//是否过滤掉系统app
     * @param packageManager
     * @param packageNames//需要验证的apk包名 mapsPackageName==null 返回手机所有已安装apk信息
     * @return
     */
    public static List<MyAppInfo> scanLocalInstallAppList(boolean system, PackageManager packageManager, ArrayList<String> packageNames) {
        List<MyAppInfo> myAppInfos = new ArrayList<MyAppInfo>();
        try {
            List<PackageInfo> packageInfos = packageManager.getInstalledPackages(0);
            for (int i = 0; i < packageInfos.size(); i++) {
                PackageInfo packageInfo = packageInfos.get(i);
                if (system) {
                    //过滤掉系统app
                    if ((ApplicationInfo.FLAG_SYSTEM & packageInfo.applicationInfo.flags) != 0) {
                        continue;
                    }
                }
                String packageName = packageInfo.packageName;
                int index = i;
                if (packageNames != null && packageNames.size() > 0) {
                    index = packageNames.indexOf(packageName);
                    if (index == -1) {
                        continue;
                    }
                    LogUtil.e("------------------------" + packageName);
                }
                MyAppInfo myAppInfo = new MyAppInfo();
                myAppInfo.setSort(index);
                myAppInfo.setPackageName(packageName);
                String str_name = packageInfo.applicationInfo.loadLabel(packageManager).toString();
                myAppInfo.setAppName(str_name);
                if (packageInfo.applicationInfo.loadIcon(packageManager) == null) {
                    continue;
                }
                myAppInfo.setImage(packageInfo.applicationInfo.loadIcon(packageManager));
                myAppInfos.add(myAppInfo);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return myAppInfos;
    }


    public static class MyAppInfo implements Serializable {
        private int sort;
        private Drawable image;
        private String appName;
        private String packageName;

        public MyAppInfo(int sort, Drawable image, String appName, String packageName) {
            this.sort = sort;
            this.image = image;
            this.appName = appName;
            this.packageName = packageName;
        }

        public MyAppInfo() {

        }

        public int getSort() {
            return sort;
        }

        public void setSort(int sort) {
            this.sort = sort;
        }

        public Drawable getImage() {
            return image;
        }

        public void setImage(Drawable image) {
            this.image = image;
        }

        public String getAppName() {
            return appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getPackageName() {
            return packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }


}
