package com.gingersoft.gsa.cloud.database.bean;

import android.graphics.Color;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.NotNull;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.ToMany;
import org.greenrobot.greendao.annotation.Transient;
import org.greenrobot.greendao.annotation.Generated;

import java.util.List;

import org.greenrobot.greendao.DaoException;

import com.gingersoft.gsa.cloud.database.greendao.DaoSession;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;
import com.gingersoft.gsa.cloud.database.greendao.ComboDao;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：套餐關係
 */
@Entity
public class Combo {

    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long dbid;

    @NotNull
    private Long id;
    private Long fid; //食品ID
    private int comId;//套餐ID

    //關聯食品表
    @ToMany(referencedJoinProperty = "id")
    private List<Food> foods;

    /**
     * 自定義字段
     */
    @Transient
    private String name;
    @Transient
    private long parentId;
    /**
     * 價格
     */
    @Transient
    private double price = 0.00;
    /**
     * 是否自動展開
     */
    @Transient
    private int autoMode = 0;
    /**
     * 是否备注细项
     */
    @Transient
    private boolean isModifier;
    /**
     * 背景顏色
     */
    @Transient
    private int bgColor = Color.parseColor("#067878");
    /**
     * 字體顏色
     */
    @Transient
    private int fontColor = Color.parseColor("#FFFFFF");
    /**
     * 套餐細項
     */
    @Transient
    private Modifier modifier;

    /**
     * Used to resolve relations
     */
    @Generated(hash = 2040040024)
    private transient DaoSession daoSession;

    /**
     * Used for active entity operations.
     */
    @Generated(hash = 1678159415)
    private transient ComboDao myDao;


    @Generated(hash = 1487508076)
    public Combo(Long dbid, @NotNull Long id, Long fid, int comId) {
        this.dbid = dbid;
        this.id = id;
        this.fid = fid;
        this.comId = comId;
    }

    @Generated(hash = 2090634475)
    public Combo() {
    }


//    @Generated(hash = 196636064)
//    public Combo(Long dbid, @NotNull Long id, Long fid, int comId) {
//        this.dbid = dbid;
//        this.id = id;
//        this.fid = fid;
//        this.comId = comId;
//    }
//
//    @Generated(hash = 2090634475)
//    public Combo() {
//    }


    public long getParentId() {
        return parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getFid() {
        return fid;
    }

    public void setFid(Long fid) {
        this.fid = fid;
    }

    public int getComId() {
        return comId;
    }

    public void setComId(int comId) {
        this.comId = comId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAutoMode() {
        return autoMode;
    }

    public void setAutoMode(int autoMode) {
        this.autoMode = autoMode;
    }

    public double getPrice() {
        return price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public boolean isModifier() {
        return isModifier;
    }

    public void setModifier(boolean modifier) {
        isModifier = modifier;
    }

    public int getBgColor() {
        return bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public int getFontColor() {
        return fontColor;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public Long getDbid() {
        return dbid;
    }

    public void setDbid(Long dbid) {
        this.dbid = dbid;
    }

    public Modifier getModifier() {
        return modifier;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public void setId(Long id) {
        this.id = id;
    }


    /**
     * To-many relationship, resolved on first access (and after reset).
     * Changes to to-many relations are not persisted, make changes to the target entity.
     */
    @Generated(hash = 696813942)
    public List<Food> getFoods() {
        if (foods == null) {
            final DaoSession daoSession = this.daoSession;
            if (daoSession == null) {
                throw new DaoException("Entity is detached from DAO context");
            }
            FoodDao targetDao = daoSession.getFoodDao();
            List<Food> foodsNew = targetDao._queryCombo_Foods(dbid);
            synchronized (this) {
                if (foods == null) {
                    foods = foodsNew;
                }
            }
        }
        return foods;
    }

    /**
     * Resets a to-many relationship, making the next get call to query for a fresh result.
     */
    @Generated(hash = 1950966)
    public synchronized void resetFoods() {
        foods = null;
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#delete(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 128553479)
    public void delete() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.delete(this);
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#refresh(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 1942392019)
    public void refresh() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.refresh(this);
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#update(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 713229351)
    public void update() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.update(this);
    }

    /**
     * called by internal mechanisms, do not call yourself.
     */
    @Generated(hash = 589205575)
    public void __setDaoSession(DaoSession daoSession) {
        this.daoSession = daoSession;
        myDao = daoSession != null ? daoSession.getComboDao() : null;
    }

    public static Combo addFoodInfo(Food food, Combo combo) {
        combo.setName(food.getFoodName());
        combo.setFid(food.getId());
        combo.setPrice(food.getPrice());
        combo.setAutoMode(food.getAutoMod());
        return combo;
    }
}
