package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.RemoteException;

import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.sunmi.peripheral.printer.InnerPrinterCallback;
import com.sunmi.peripheral.printer.InnerPrinterException;
import com.sunmi.peripheral.printer.InnerPrinterManager;
import com.sunmi.peripheral.printer.InnerResultCallbcak;
import com.sunmi.peripheral.printer.SunmiPrinterService;

/**
 * Created by Wyh on 2020/2/10.
 */
public class SunMiPrint {

    public static boolean bindService(Context context, InnerPrinterCallback callback) {
        try {
            return InnerPrinterManager.getInstance().bindService(context, callback);
        } catch (InnerPrinterException e) {
            e.printStackTrace();
            ToastUtils.show(context, "連接失敗，錯誤信息：" + e.getMessage());
            return false;
        }
    }

    public static boolean printBitmap(Context context, Bitmap bitmap) {
        return bindService(context, new InnerPrinterCallback() {
            @Override
            protected void onConnected(SunmiPrinterService service) {
                //驗證打印機狀態
                if (PrintStatus.initV2PrintStatus(context, service)) {
                    try {
                        //打印機狀態正常，開始打印圖片
                        service.printBitmap(bitmap, new InnerResultCallbcak() {
                            @Override
                            public void onRunResult(boolean isSuccess) {
                                //返回接⼝执⾏的情况(并⾮真实打印):成功或失败
                                if (isSuccess) {
                                    ToastUtils.show(context, "打印成功");
                                } else {
                                    ToastUtils.show(context, "打印失敗");
                                }
                            }

                            @Override
                            public void onReturnString(String result) {
                                //部分接⼝会异步返回查询数据
                                ToastUtils.show(context, "onReturnString：" + result);
                            }

                            @Override
                            public void onRaiseException(int code, String msg) {
                                //接⼝执⾏失败时，返回的异常状态
                                ToastUtils.show(context, "打印異常狀態碼：" + code + "---MSG:" + msg);
                            }

                            @Override
                            public void onPrintResult(int code, String msg) {
                                //事务模式下真实的打印结果返回
                                ToastUtils.show(context, "打印結果：" + code + "---MSG:" + msg);
                            }
                        });
                    } catch (RemoteException e) {
                        e.printStackTrace();
                        //如部分接⼝只能⽤于指定机型所以会跑出调⽤接⼝异常，如钱箱接⼝只能⽤于台式机
                        ToastUtils.show(context, "打印失敗" + "msg:" + e.getMessage());
                    }
                }
            }

            @Override
            protected void onDisconnected() {
                ToastUtils.show(context, "斷開連接");
            }
        });
    }

}
