package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

import androidx.recyclerview.widget.GridLayoutManager;
import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class FoodGroupAdapter extends DefaultAdapter<Food> {

    private Context mContext;

//    private List<Color.DatasBean> mColorList;
    private int mOrderNumberShowSize;
    private int mOrderNumberFontSize;
    private int FoodTypeFontSize;

    private int mParentRowCount;
    private int mParentColWidth;
    private int mParentColHeight;
    private int mLayoutQtyHeight;

    private int currentSelectPosition = 0;

    public FoodGroupAdapter(Context context, List<Food> infos) {
        super(infos);
        this.mContext = context;

//        this.mOrderNumberShowSize = GSAApplication.androidSetting.getOrderNumberShowSize();
//        this.mOrderNumberFontSize = GSAApplication.androidSetting.getOrderNumberFontSize();
//        this.FoodTypeFontSize = GSAApplication.androidSetting.getFoodTypeFontSize();
//        int foodCol = GSAApplication.androidSetting.getFoodTypeCol();
//        this.mParentColWidth = (int) (DeviceUtils.getScreenWidth(context) / foodCol);
//
//        this.mParentColHeight = GSAApplication.androidSetting.getLayoutFoodTypeHeight() / GSAApplication.androidSetting.getFoodTypeRow();
//        this.mLayoutQtyHeight = GSAApplication.androidSetting.getLayoutQtyHeight();
//
//        Db_Color dc = new Db_Color(context);
//        mColorList = dc.query("");
//        dc.closeDb();
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Food> getHolder(View v, int viewType) {
        return new FoodlKindItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_food_group;
    }

    class FoodlKindItemHolder extends BaseHolder<Food> {

        @BindView(R2.id.rl_container)
        RelativeLayout rl_container;
        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.tv_number)
        TextView tv_number;
        @BindView(R2.id.tv_soldout)
        TextView tv_soldout;

        public FoodlKindItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Food datasBean, int position) {

            setFoodGroup(datasBean);
            setNumber(datasBean);
            setSoldoutStatus(datasBean);

            setOnItemClickListener(new OnViewClickListener() {

                @Override
                public void onViewClick(View view, int position) {
                    if (mOnItemClickListener != null) {

                        if (currentSelectPosition != position) {
                            //设置当前选中item颜色
                            datasBean.setSelected(true);
                            tv_name.setBackgroundColor(mContext.getResources().getColor(R.color.colorAccent));

                            //重置上次选中item的颜色
                            mInfos.get(currentSelectPosition).setSelected(false);
                            notifyItemChanged(currentSelectPosition, 1);
                            //保存上次操作的position
                            currentSelectPosition = position;
                        }

                        mOnItemClickListener.onItemClick(datasBean, position);
                    }
                }
            });
        }

        public void setFoodGroup(Food datasBean) {
//            String desc = "";
//            switch (GSAApplication.androidSetting.getDataLanguage()) {
//                case 1:
//                    desc = datasBean.getDesc1();
//                    break;
//                case 2:
//                    desc = datasBean.getDesc2();
//                    break;
//                case 3:
//                    desc = datasBean.getDesc3();
//                    break;
//            }
//            if (desc == null || desc.trim().length() == 0) {
//                desc = datasBean.getDesc1();
//            }
            tv_name.setMaxHeight(50);
            tv_name.setMinHeight(50);
            tv_name.setHeight(50);

            tv_name.setMaxWidth(mParentColWidth);
            tv_name.setMinWidth(mParentColWidth);
            tv_name.setWidth(mParentColWidth);

            tv_name.setText(datasBean.getFoodName());
            tv_name.setTextSize(FoodTypeFontSize);
            tv_name.setHeight(mParentColHeight);
            tv_name.setGravity(Gravity.CENTER);

            GridLayoutManager.LayoutParams lp = (GridLayoutManager.LayoutParams) rl_container.getLayoutParams();
            lp.height = mParentColHeight;
            lp.width = mParentColWidth;
            rl_container.setLayoutParams(lp);

            /**
             * 设置字体颜色以及块颜色
             */
//            if (mColorList != null) {
//                //后台有设置颜色当前选中高亮色,没有选中默认使用后台配置的颜色
//                if (datasBean.isSelected()) {
//                    tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.colorAccent));
//                    tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                } else {
//                    for (Color.DatasBean cs : mColorList) {
//                        String color = cs.getAndroidColor();
//                        String fontcolor = cs.getAndroidfontcolor();
//                        if (cs.getColorid() == datasBean.getColorID()) {
//                            if (!TextUtils.isEmpty(color)) {
//                                tv_name.setBackgroundColor(android.graphics.Color.parseColor(color));
//                            } else {
//                                tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
//                            }
//                            if (!TextUtils.isEmpty(fontcolor)) {
//                                tv_name.setTextColor(android.graphics.Color.parseColor(fontcolor));
//                            } else {
//                                tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                            }
//                            break;
//                        }
//                    }
//                }
//            } else {
//                //后台没有设置颜色当前选中高亮色,没有选中默认使用绿色
            if (datasBean.isSelected()) {
                    tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.orange_500));
                    tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                } else {
                    tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
                    tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                }
//            }
        }

        public void setNumber(Food datasBean) {
            tv_number.setTextSize(10);
            tv_number.setHeight(mLayoutQtyHeight);

            ViewGroup.MarginLayoutParams mp = new ViewGroup.MarginLayoutParams(mOrderNumberShowSize, mOrderNumberShowSize);  //item�Ŀ��
            mp.setMargins(0, 0, 0, 0);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(mp);
            lp.width = ArmsUtils.dip2px(mContext, 16);
            lp.height = ArmsUtils.dip2px(mContext, 16);
            tv_number.setLayoutParams(lp);

            if (datasBean.getNumber() == 0) {
                tv_number.setVisibility(View.INVISIBLE);
            } else {
                tv_number.setVisibility(View.VISIBLE);
                tv_number.setText(datasBean.getNumber()  + "");
            }
        }

        public void setSoldoutStatus(Food datasBean) {
            tv_soldout.setMaxHeight(mOrderNumberShowSize);
            tv_soldout.setMinHeight(mOrderNumberShowSize);
            tv_soldout.setTextSize(mOrderNumberFontSize);

//            String qty = datasBean.getOR_Qty();
//            if (TextUtils.isEmpty(qty)) {
//                tv_soldout.setVisibility(View.INVISIBLE);
//            } else {
//                tv_soldout.setVisibility(View.VISIBLE);
                tv_soldout.setText(datasBean.getNumber());
//            }

            /**
             * 设置当前状态
             */
//            if (mCurrentSlodoutFoodList_Full != null) {
//                for (CurrentSoldoutFood.DatasBean sc : mCurrentSlodoutFoodList_Full) {
//                    if (sc.getItemID().equals(datasBean.getFID()) && sc.getType().equals("G")) {
//                        if (sc.get_QtyName().equals("")) {
//                            tv_soldout.setVisibility(View.INVISIBLE);
//                        } else {
//                            tv_soldout.setVisibility(View.VISIBLE);
//                            tv_soldout.setText(sc.get_QtyName());
//                        }
//                    }
//                }
//            }
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Food datasBean, int position);

    }
}
