package com.gingersoft.supply_chain.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.server.SupplierServer;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.FoodUnitPageContract;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2020 16:05
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class FoodUnitPageModel extends BaseModel implements FoodUnitPageContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public FoodUnitPageModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getDeputyUnitList(int brandId, int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getDeputyUnitList(brandId, restaurantId);
    }

    @Override
    public Observable<BaseResult> updateDeputyUnitList(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).updateDeputyUnitList(requestBody);
    }

    @Override
    public Observable<BaseResult> updateDeputyUnit(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).updateDeputyUnit(requestBody);
    }

    @Override
    public Observable<BaseResult> addBasicUnit(RequestBody requestBody) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).addDeputyUnitInput(requestBody);
    }

    @Override
    public Observable<BaseResult> deleteUnitKey(int id) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).deleteUnitKey(id);

    }
}