package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.view.View;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.WarehouseDetailsBean;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WarehouseDetailsFragment;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/22
 * Time: 14:45
 * Use:
 */
public class WareHousingDetailsAdapter extends BaseQuickAdapter<WarehouseDetailsBean, BaseViewHolder> {
    /**
     * 入庫還是出庫
     * 入庫顯示+，出庫顯示-
     */
    private int type;

    //已消耗的背景色 shape_oval_48
    //已過期的背景 shape_oval_red_wine
    //即將過期背景 shape_oval_bright_orange

    public WareHousingDetailsAdapter(@Nullable List<WarehouseDetailsBean> data, int type) {
        super(R.layout.item_warehouse_details, data);
        this.type = type;
        addChildClickViewIds(R.id.tv_warehouse_details_food_num);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, WarehouseDetailsBean item) {
        //食品名
        viewHolder.setText(R.id.tv_warehouse_details_food_name, item.getName());
        //入庫單位
        viewHolder.setText(R.id.tv_warehouse_details_food_unit, item.getUnitName());
        //入庫食品數量
//        if (item.getFoodQuantity() > 0) {
        if (type == WarehouseDetailsFragment.WAREHOUSE_TYPE) {
            // 入庫，顯示+
            setWarehousingData(viewHolder, item);
        } else {
            //出庫，顯示-
            setOutStockData(viewHolder, item);
        }
        //供應商
        viewHolder.setText(R.id.tv_warehouse_details_supplier, item.getSupplierName());
        //入庫來源
        viewHolder.setText(R.id.tv_warehouse_details_reason, item.getPurchase());
        //設置狀態
        TextView tvState = viewHolder.getView(R.id.tv_warehouse_state);
        TextView tvExpiresTime = viewHolder.getView(R.id.tv_warehouse_expires_time);
        if (item.getConsumeStatus() == WarehouseDetailsBean.WAREHOUSE_STATE_ALL_CONSUMED) {
            //全部消耗了
            tvState.setText("庫存已使用");
            tvState.setTextColor(ContextCompat.getColor(getContext(), R.color.required_color));
            tvState.setVisibility(View.VISIBLE);
            //全部消耗的就不顯示過期時間
            tvExpiresTime.setVisibility(View.GONE);
        } else {
            //部分消耗
            if (item.getConsumeStatus() == WarehouseDetailsBean.WAREHOUSE_STATE_PART_CONSUMED) {
                tvState.setText("部分使用");
                tvState.setTextColor(ContextCompat.getColor(getContext(), R.color.bright_orange));
                tvState.setVisibility(View.VISIBLE);
            } else {
                tvState.setVisibility(View.GONE);
            }
            if (item.getDistanceExpiresTime() >= 0) {
                //即將過期天數大於等於0
                if (item.getWarningDays() > item.getDistanceExpiresTime()) {
                    //在預警天數內
                    //顯示即將過期
                    setExpiresTime(tvExpiresTime, R.drawable.shape_oval_bright_orange, "即将過期：", item.getDistanceExpiresTime());
                } else {
                    tvExpiresTime.setVisibility(View.GONE);
                    tvState.setVisibility(View.GONE);
                }
            } else {
                //天數為負，則是已過期
                setExpiresTime(tvExpiresTime, R.drawable.shape_oval_red_wine, "已過期：", Math.abs(item.getDistanceExpiresTime()));
            }
        }
    }

    /**
     * 設置出庫數據
     */
    private void setOutStockData(@NotNull BaseViewHolder viewHolder, WarehouseDetailsBean item) {
        if (!item.isQueriesNumber()) {
            viewHolder.setGone(R.id.tv_warehouse_details_food_num, true);
        } else {
            viewHolder.setGone(R.id.tv_warehouse_details_food_num, false);
            if (item.getFoodQuantity() >= 0) {
                //如果大於0，前面顯示-號
                viewHolder.setText(R.id.tv_warehouse_details_food_num, String.format(getContext().getString(R.string.str_format_less), item.getFoodQuantity() + ""));
            } else {
                //小於0，顯示正數，負負得正
                viewHolder.setText(R.id.tv_warehouse_details_food_num, String.format(getContext().getString(R.string.str_format_positive), Math.abs(item.getFoodQuantity()) + ""));
            }
            // 入庫顯示消耗日期，不顯示入庫日期
            viewHolder.setGone(R.id.tv_warehouse_time_text, true);
            //消耗日期
            viewHolder.setText(R.id.tv_warehouse_order_time_text, String.format(getContext().getString(R.string.str_format_consumption_date), item.getPurchaseTime()));
            //顯示備註
            viewHolder.setGone(R.id.tv_warehouse_details_remarks, false);
            if (TextUtil.isNotEmptyOrNullOrUndefined(item.getRemarks())) {
                viewHolder.setText(R.id.tv_warehouse_details_remarks, String.format(getContext().getString(R.string.str_format_remark_colon), item.getRemarks()));
            }
        }
    }


    /**
     * 設置入庫數據
     */
    private void setWarehousingData(@NotNull BaseViewHolder viewHolder, WarehouseDetailsBean item) {
        if (item.getFoodQuantity() >= 0) {
            //如果大於0，前面顯示+號
            viewHolder.setText(R.id.tv_warehouse_details_food_num, String.format(getContext().getString(R.string.str_format_positive_int), item.getFoodQuantity()));
        } else {
            //小於0，直接顯示負數
            viewHolder.setText(R.id.tv_warehouse_details_food_num, String.valueOf(item.getFoodQuantity()));
        }
        if (TextUtil.isEmptyOrNullOrUndefined(item.getPurchaseTime()) && TextUtil.isNotEmptyOrNullOrUndefined(item.getWarehousingTime())) {
            //下單時間為空，入庫時間不為空
            //下單時間改為入庫時間，隱藏入庫時間控件
            viewHolder.setText(R.id.tv_warehouse_order_time_text, String.format(getContext().getString(R.string.str_format_warehousing_date), item.getWarehousingTime()));
            viewHolder.setGone(R.id.tv_warehouse_time_text, true);
        } else {
            viewHolder.setText(R.id.tv_warehouse_order_time_text, String.format(getContext().getString(R.string.str_format_order_date), item.getPurchaseTime()));
            viewHolder.setText(R.id.tv_warehouse_time_text, String.format(getContext().getString(R.string.str_format_warehousing_date), item.getWarehousingTime()));
            viewHolder.setGone(R.id.tv_warehouse_time_text, false);
        }
        viewHolder.setGone(R.id.tv_warehouse_details_remarks, true);
    }

    private void setExpiresTime(TextView tvExpiresTime, int p, String s, int distanceExpiresTime) {
        tvExpiresTime.setBackground(ContextCompat.getDrawable(getContext(), p));
        tvExpiresTime.setText(s + distanceExpiresTime + "日");
        tvExpiresTime.setVisibility(View.VISIBLE);
    }

    public void setType(int type) {
        this.type = type;
    }
}
