package com.gingersoft.gsa.cloud.table.mvp.contract;

import android.app.Activity;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.meal.MealStandActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.CancelFoodDialog;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/17/2021 10:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface MealStandContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends BaseMealContract.View {

        void setCurrViewMode(int... viewMode);

        void showChoosePeopleNumDialog(boolean isNeedCancel);

        void showCancelFoodDialog(OrderDetail deleteFood);

        void setCustomFoodDialog(int customType, OrderDetail foodItem);

        CancelFoodDialog getCancelFoodDialog();

        void setFoodGroupRecycleSpanCount(int size);

        void setFoodRecycleSpanCount(int size);

        void setComboRecycleSpanCount(int size);

        void setModifierRecycleSpanCount(int size);

        void showViewModeVisibility(int... viewMode);

        void showModifyLayoutVisibility(boolean show);

        void showStandOperLayoutVisibility(boolean show);

        void setOrderFoodCount(String number);

        int getCurrentViewMode();

        void setPluMode();

        void resetPluMode();

        void setMealRvScrollToPosition(int position);

        void resetSelect(int position, Food datasBean);

        void initFoodGroupAdapter(List<Food> foodGroupList);

        void updateCouponSelects(boolean sticky);

        void notifyFoodGroupAdapter();

        void notifyFoodAdapter();

        void notifyComboAdapterAdapter();

        void notifyModifierAdapterAdapter();

        Activity getActivity();

        int getFromType();

        void clearKeyBoardInput();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends BaseMealContract.Model {

        Single<BaseResult> getCurrentSoldoutFood(RequestBody requestBody);

        Single<BaseResult> createOrder(RequestBody requestBody);

        Single<BaseResult> addOrderFood(RequestBody requestBody);

        Single<BaseResult> getRestaurantFoodReason(int brandId, int restaurantId, int type);

        List<Food> queryDB_FoodGroupList(int foodSummary);

        List<Food> queryDB_FoodList(long parentId, int foodSummary);

        Food queryFoodByFlu(String plu);

        List<Modifier> queryDB_ModifierList(long fid, int mode);

        List<ComboItem> queryDB_ComboList(long fid, int foodSummary);

        List<FoodCombo> isComboFood(long fid);

    }


}
