package com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.rxjava.ErrorHandleSingleSubscriber;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.annotations.NonNull;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.RiceponMemberDialogContract;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/24/2021 16:24
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class RiceponMemberDialogPresenter extends BasePresenter<RiceponMemberDialogContract.Model, RiceponMemberDialogContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public RiceponMemberDialogPresenter(RiceponMemberDialogContract.Model model, RiceponMemberDialogContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void queryMember(int type, String parm, String shopName, int tableId, String tableNumber) {
        mModel.queryMember(type, parm, shopName, tableId, tableNumber)
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSingleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onSuccess(@NonNull BaseResult info) {
                        if (info != null && info.isSuccess()) {
                            if (info.getData() != null) {
                                MemberInfo memberInfo = GsonUtils.GsonToBean(info.getData(), MemberInfo.class);
                                if (memberInfo != null && memberInfo.getId() != 0) {
                                    mRootView.returnMemberInfo(memberInfo);
                                } else {
                                    mRootView.showMessage("未找到相關會員電話號碼,請重新輸入");
                                }
                            } else {
                                mRootView.showMessage("獲取會員信息失敗");
                            }
                        } else {
                            mRootView.showMessage(info.getErrMsg());
                        }
                    }
                });
    }

    public List<SectionTextItem> getMemberInfoItem(MemberInfo memberInfo) {
        List<SectionTextItem> textItems = new ArrayList<>();
        textItems.add(new SectionTextItem("會員號碼: " + memberInfo.getMemberNo()));
        textItems.add(new SectionTextItem("會員電話: " + memberInfo.getPhone()));
        textItems.add(new SectionTextItem("會員名稱: " + memberInfo.getMemberName()));
        textItems.add(new SectionTextItem("會員等級: " + memberInfo.getLevelName()));
        textItems.add(new SectionTextItem("積分: " + memberInfo.getMemberPoint()));
        return textItems;
    }
}
