package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.common.constans.AppConstant;
import com.gingersoft.gsa.cloud.common.constans.OrderTypeConstans;
import com.gingersoft.gsa.cloud.common.utils.LanguageUtils;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.order.contract.OrderStatusContract;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.google.android.material.checkbox.MaterialCheckBox;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.Date;
import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */
public class OrderCenterAdapter extends DefaultAdapter<OrderManagerResponse> {

    private Context mContext;

    public OrderCenterAdapter(Context context, List<OrderManagerResponse> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<OrderManagerResponse> getHolder(View v, int viewType) {
        return new OrderCenterItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.item_order_center;
    }

    class OrderCenterItemHolder extends BaseHolder<OrderManagerResponse> {

        @BindView(R2.id.rl_root_container)
        RelativeLayout rl_root_container;
        @BindView(R2.id.cb_order)
        MaterialCheckBox cb_order;
        @BindView(R2.id.tv_table_name)
        TextView tv_table_name;
        @BindView(R2.id.tv_order_num)
        TextView tv_order_num;
        @BindView(R2.id.tv_people_num)
        TextView tv_people_num;
        @BindView(R2.id.tv_open_time)
        TextView tv_open_time;
        @BindView(R2.id.tv_pay_time)
        TextView tv_pay_time;
        @BindView(R2.id.tv_pay_money_text)
        TextView tv_pay_money_text;
        @BindView(R2.id.tv_pay_money)
        TextView tv_pay_money;

        @BindView(R2.id.horizontal_dividing_line)
        View horizontal_dividing_line;
        @BindView(R2.id.tv_reload_exception_status)
        TextView tv_reload_exception_status;

        public OrderCenterItemHolder(View orderBeanView) {
            super(orderBeanView);
        }

        @Override
        public void setData(OrderManagerResponse orderBean, int position) {

            setOrderItemDetail(orderBean);
            setBtnListener(orderBean);

            rl_root_container.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(orderBean, position);
                    }
                }
            });
        }

        private void setOrderItemDetail(OrderManagerResponse orderBean) {
            String pax = LanguageUtils.get_language_system( "Meal.Mannumber", "人數") + "：";
            String amountText = LanguageUtils.get_language_system( "amount", "金額:");
            String orderCode = LanguageUtils.get_language_system( "order.code", "訂單碼") + ": ";
            String mealCode = LanguageUtils.get_language_system( "meal.code", "取餐碼") + ": ";

            if (!TextUtils.isEmpty(orderBean.getCreateTime())) {
                String openTable = LanguageUtils.get_language_system("open.table", "開台") + "：";
                String createTime = TimeUtils.getStringByFormat(new Date(orderBean.getCreateTime()), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM);
                tv_open_time.setText(openTable + "：" + createTime);
            } else {
                tv_open_time.setVisibility(View.GONE);
            }
            if (!TextUtils.isEmpty(orderBean.getEndTime())) {
                String payBill = LanguageUtils.get_language_system("opentable.paybill", "結賬");
                String payBillTime = TimeUtils.getStringByFormat(new Date(orderBean.getEndTime()), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM);
                tv_pay_time.setText(payBill + "：" + payBillTime);
            } else {
                tv_pay_time.setVisibility(View.GONE);
            }
            if (orderBean.getOrderType() == OrderTypeConstans.order_type_2) {
                tv_table_name.setText("外賣");
                tv_order_num.setText(orderCode + orderBean.getTakeFoodCode());
            } else if (orderBean.getOrderType() == OrderTypeConstans.order_type_7) {
                tv_table_name.setText("自取");
                tv_order_num.setText(orderCode + orderBean.getBillNo() + "  " + mealCode + orderBean.getTakeFoodCode());
            } else {
                String tableName = LanguageUtils.get_language_system( "table.number", "檯號") + ": ";
                String orderNumber = LanguageUtils.get_language_system( "order.number", "單號") + ": ";
                tv_table_name.setText(tableName + orderBean.getTableName());
                tv_order_num.setText(orderNumber + orderBean.getOrderNo());
            }
            tv_people_num.setText(pax + orderBean.getPerson());
            tv_pay_money_text.setText(amountText);
            tv_pay_money.setText(AppConstant.CARSH_STR + orderBean.getTotalAmount());
            //先将check回调情况，防止setChecked时反复调用onCheckedChanged方法
            cb_order.setOnCheckedChangeListener(null);
            if (orderBean.getStatus() == OrderStatusContract.STATUS_6) {
                cb_order.setVisibility(View.GONE);
            } else {
                cb_order.setChecked(orderBean.isChecked());
            }
        }

        private void setBtnListener(OrderManagerResponse orderBean) {
            if (orderBean.getStatus() != OrderStatusContract.STATUS_6) {
                if (orderBean.isCurrDeviceOrder()) {
                    if (orderBean.getMatterStatus() == OrderManagerResponse.MATTER_STATUS_SUCCESS) {
                        cb_order.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
                            @Override
                            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                                for (int i = 0; i < mInfos.size(); i++) {
                                    OrderManagerResponse orderBean = mInfos.get(i);
                                    orderBean.setChecked(false);
                                }
                                orderBean.setChecked(isChecked);
                                notifyDataSetChanged();
                                if (mOnItemClickListener != null) {
                                    mOnItemClickListener.onCheckedChanged(orderBean);
                                }
                            }
                        });
                        tv_reload_exception_status.setText("");
                        tv_reload_exception_status.setVisibility(View.GONE);
                        tv_reload_exception_status.setOnClickListener(null);
                        horizontal_dividing_line.setVisibility(View.VISIBLE);
                        rl_root_container.setBackgroundResource(R.drawable.shape_rect_radius_white_5);
                    } else {
                        cb_order.setOnCheckedChangeListener(null);
                        tv_reload_exception_status.setText(orderBean.getExceptionReloadText());
                        tv_reload_exception_status.setVisibility(View.VISIBLE);
                        tv_reload_exception_status.setOnClickListener(new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                if (mOnItemClickListener != null) {
                                    mOnItemClickListener.onReloadExceptionStatus(orderBean, orderBean.getMatterTxnId());
                                }
                            }
                        });
                        horizontal_dividing_line.setVisibility(View.GONE);
                        rl_root_container.setBackgroundResource(R.drawable.shape_rect_radius_transparent_5);
                    }
                } else {
                    //非当前POS设备不可操作
                    cb_order.setVisibility(View.GONE);
                    cb_order.setOnCheckedChangeListener(null);
                }
            }
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(OrderManagerResponse datasBean, int position);

        void onCheckedChanged(OrderManagerResponse checkedOrder);

        void onReloadExceptionStatus(OrderManagerResponse datasBean, String txnId);

    }
}
