package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.mealstand;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerMealFineComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealFineContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.MealFinePresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.meal.MealStandActivity;
import com.gingersoft.gsa.cloud.ui.adapter.ViewPager2Adapter;
import com.gingersoft.gsa.cloud.ui.utils.QMUITabSegmentUtils;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabBuilder;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment;
import com.qmuiteam.qmui.widget.tab.QMUITabSegment2;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/24/2021 18:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class MealFineFragment extends BaseFragment<MealFinePresenter> implements MealFineContract.View {

    @BindView(R2.id.tabSegment)
    QMUITabSegment2 tabSegment;
    @BindView(R2.id.viewPager)
    ViewPager2 viewPager;
    @BindView(R2.id.ll_container)
    QMUILinearLayout llContainer;

    private String[] mTabList = {"口味", "信息"};

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerMealFineComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_fine, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initViewPager();
    }

    @OnClick(R2.id.iv_fine_back)
    void onFineBackViewClick(View view) {
        killMyself();
    }

    private void initViewPager() {

        QMUITabBuilder builder = tabSegment.tabBuilder();

        for (final String tabTitle : mTabList) {
            QMUITab tab = builder
                    .setText(tabTitle)
                    .build(mContext);
            tabSegment.addTab(tab);
        }

        viewPager.setAdapter(new ViewPager2Adapter(this, createFragments()));
        viewPager.setCurrentItem(0);
        tabSegment.addOnTabSelectedListener(new QMUITabSegment.OnTabSelectedListener() {

            @Override
            public void onTabSelected(int index) {
                LoganManager.w_tableMode(TAG, "當前頁面【" + mTabList[index] + "】");
            }

            @Override
            public void onTabUnselected(int index) {
            }

            @Override
            public void onTabReselected(int index) {
            }

            @Override
            public void onDoubleTap(int index) {
            }
        });
        QMUITabSegmentUtils.setNomalTabSegmentStyle(tabSegment, viewPager);
    }

    private List<Fragment> createFragments() {
        List<Fragment> fragments = new ArrayList<>();
        MealFineAllFragment modSasteFineItemFragment = MealFineAllFragment.newInstance();
        MealFineAllFragment modMsgFineItemFragment = MealFineAllFragment.newInstance();
        fragments.add(modSasteFineItemFragment);
        fragments.add(modMsgFineItemFragment);
        return fragments;
    }

    public void setCurrentItem(int currFinePage) {
        viewPager.setCurrentItem(currFinePage);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(_mActivity, message, true);
        else
            LoadingDialog.showDialogForLoading(_mActivity);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(_mActivity, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
    }


}
