package com.gingersoft.gsa.cloud.table.mvp.action.discount;

import android.app.Activity;
import android.text.InputType;
import com.gingersoft.gsa.cloud.common.core.discount.MemberCoupon;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.order.discount.NomalDiscount;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.gingersoft.gsa.cloud.ui.widget.dialog.KeyboardDialog;
import com.jess.arms.utils.ArmsUtils;

import java.util.List;

/**
 * @author : bin
 * @create date: 2020-10-27
 * @update date: 2020-10-27
 * @description:食品優惠券邏輯
 */
public class MealCouponAction implements Strategy<MemberCoupon> {

    private Activity mContext;

    /**
     * 食品優惠券列表
     */
    private List<NomalDiscount> mNomalDiscountList;

    private OnCallBackListener mListener;

    public MealCouponAction(Activity context, OnCallBackListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public void setNomalDiscountList(List<NomalDiscount> nomalDiscountList) {
        this.mNomalDiscountList = nomalDiscountList;
    }

    @Override
    public void action(MemberCoupon discount) {
        if (mListener == null) {
            return;
        }


    }

    @Override
    public void destroy() {

    }

    private void exclusiveDiscount(MemberCoupon discount) {
        if (mListener != null) {
        }
    }

    /**
     * 是否有獨佔折扣
     *
     * @return
     */
    private boolean hasExclusiveDiscount() {
        for (NomalDiscount nomalDiscount : mNomalDiscountList) {
            if (nomalDiscount.getDiscount().getExclusive() == 1) {
                return true;
            }
        }
        return false;
    }

    public interface OnCallBackListener {

        void exclusiveRemoveOthers(List<NomalDiscount> nomalDiscountList);

        void preformAddDiscount(MemberCoupon discount);
    }

}
