package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.core.table.TableManagerItem;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.gingersoft.gsa.cloud.ui.recylcler.event.OnRecyclerItemClickListener;
import com.gingersoft.gsa.cloud.ui.recylcler.event.RecyItemTouchHelperCallback;
import com.gingersoft.gsa.cloud.ui.widget.dialog.CommonTipDialog;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.main.mvp.contract.OriginalPrintPaperContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.OriginalPrintPaperPresenter;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUITopBar;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionLayout;

import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/25/2021 09:39
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class OriginalPrintPaperActivity extends BaseFragmentActivity<OriginalPrintPaperPresenter> implements OriginalPrintPaperContract.View {

    @BindView(R2.id.top_bar)
    QMUITopBar mTopBar;
    @BindView(R2.id.section_kitchen_prj)
    QMUIStickySectionLayout mSectionLayout;


    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerOriginalPrintPaperComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_original_print_paper; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initStickyLayout();
    }

    @Override
    public void initIntent() {

    }

    private void initStickyLayout() {
        mSectionLayout.setLayoutManager(createLayoutManager());
        mAdapter = new TableManageSectiontAdapter();
        mAdapter.setCallback(new QMUIStickySectionAdapter.Callback<SectionHeader, TableManagerItem>() {

            @Override
            public void loadMore(QMUISection<SectionHeader, TableManagerItem> section, boolean loadMoreBefore) {

            }

            @Override
            public void onItemClick(QMUIStickySectionAdapter.ViewHolder holder, int position) {
                if (holder instanceof TableManageSectiontAdapter.ViewHolder) {
                    TableManageSectiontAdapter.ViewHolder viewHolder = (TableManageSectiontAdapter.ViewHolder) holder;
                    if (viewHolder.getTvName().getText() != null) {
                        TableManagerItem item = viewHolder.getTableItem(position);
                        if (item.getLayoutType() == 1) {
                            start(AddTableFragment.newInstance(item));
                        } else {
                            if (isRadioEdit) {
                                item.setChecked(!item.isChecked());
                                mAdapter.notifyItemChanged(position);
                            } else {
                                if (item.getUseStatus() == 0 && item.getStatus() == 0) {
                                    start(AddTableFragment.newInstance(item));
                                } else {
                                    CommonTipDialog.showSurpisedDialog(mActivity, item.getTableName() + "檯正在使用中", null, null, null, null, null);
                                }
                            }
                        }
                    }
                } else {
                    //點擊的頭部，折疊
                }
            }

            @Override
            public boolean onItemLongClick(QMUIStickySectionAdapter.ViewHolder holder, int position) {
                return false;
            }
        });
        mSectionLayout.getRecyclerView().addItemDecoration(new RecyclerView.ItemDecoration() {
            @Override
            public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                if (view instanceof TextView) {
                    int margin = QMUIDisplayHelper.dp2px(getContext(), 10);
                    outRect.set(margin, margin, margin, margin);
                } else {
                    outRect.set(5, 5, 5, 5);
                }
            }
        });

        RecyItemTouchHelperCallback itemTouchHelperCallback = new RecyItemTouchHelperCallback(mAdapter);
        final ItemTouchHelper itemTouchHelper = new ItemTouchHelper(itemTouchHelperCallback);
        itemTouchHelper.attachToRecyclerView(mSectionLayout.getRecyclerView());

        mSectionLayout.getRecyclerView().addOnItemTouchListener(new OnRecyclerItemClickListener(mSectionLayout.getRecyclerView()) {

            @Override
            public void onItemClick(RecyclerView.ViewHolder viewHolder) {
            }

            @Override
            public void onLongClick(RecyclerView.ViewHolder viewHolder) {
//                QMUIStickySectionAdapter.ViewHolder viewHolder1 = (QMUIStickySectionAdapter.ViewHolder) viewHolder;
//                Toast.makeText(mActivity, "長按：" + viewHolder1.getAdapterPosition(), Toast.LENGTH_SHORT).show();
//                if (viewHolder.getLayoutPosition() != 0) {
//                    itemTouchHelper.startDrag(viewHolder);
//                }
            }
        });
        mSectionLayout.setAdapter(mAdapter, true);
    }

    private RecyclerView.LayoutManager createLayoutManager() {
        final GridLayoutManager layoutManager = new GridLayoutManager(this, 2, LinearLayoutManager.VERTICAL, false);
        layoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
            @Override
            public int getSpanSize(int i) {
                return mAdapter.getItemIndex(i) < 0 ? layoutManager.getSpanCount() : 1;
            }
        });
        return layoutManager;
    }

    @Override
    public void initTopBar() {
        mTopBar.setBackgroundColor(ContextCompat.getColor(mContext, R.color.theme_color));
        mTopBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        mTopBar.setTitle("廚房單原圖").setTextColor(ContextCompat.getColor(mContext, R.color.theme_white_color));
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
